/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.msg.NewsCompanyRelationshipDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.msg.NewsnoticePoliceDao;
import com.bcxin.ars.dao.msg.NewsnoticeRecipientDao;
import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.SaaSCompany;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.msg.NewsnoticePoliceSearchDto;
import com.bcxin.ars.dto.page.NewsnoticePolicePageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.NewsCompanyRelationship;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.bcxin.ars.model.msg.NewsnoticePolice;
import com.bcxin.ars.model.msg.NewsnoticeRecipient;
import com.bcxin.ars.model.msg.SAASMessage;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.service.msg.NewsnoticePoliceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=NewsnoticePolice.class, getSeq=30000, getDataSyncType=SyncType.SYNC)
@DataSyncOutAnnotation(getClazz=NewsnoticePolice.class, getSeq=30000, getDataSyncType=SyncType.SYNC, getMethodName="saveOrUpdateForImport", getImportType=ImportType.FOREACH)
public class NewsnoticePoliceServiceImpl
implements NewsnoticePoliceService {
    private static final Logger logger = LoggerFactory.getLogger(NewsnoticePoliceServiceImpl.class);
    @Autowired
    private NewsnoticePoliceDao newsnoticePoliceDao;
    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;
    @Autowired
    private SysAttachmentDao sysAttachmentDao;
    @Autowired
    private NewsnoticeRecipientDao newsnoticeRecipientDao;
    @Autowired
    private NewsCompanyRelationshipDao newsCompanyRelationshipDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private ConfigUtils configUtils;

    public void saveOrUpdate(NewsnoticePolice notice) {
        int n;
        SysAttachment dbSysAttachment;
        User currentUser = this.arsUtil.getCurrentUser();
        if (StringUtil.isNotEmpty((String)notice.getTemporaryState()) && notice.getTemporaryState().equals("1")) {
            notice.setSendTime(new Date());
        }
        if (notice.getId() == null) {
            notice.setActive(Boolean.valueOf(true));
            notice.setCreateTime(new Date());
            notice.setUpdateTime(new Date());
            notice.setUpdateBy(currentUser.getUsername());
            notice.setSendId(currentUser.getId());
            notice.setSendName(currentUser.getRealname());
            notice.setSendOrgName(currentUser.getPolice().getOrgname());
            notice.setSendOrgId(currentUser.getPolice().getId());
            notice.setAreaCode(currentUser.getPolice().getAreacode());
            notice.setUndoState("0");
            notice.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticePoliceDao.save(notice);
        } else {
            NewsnoticePolice dbNotice = this.newsnoticePoliceDao.findById(notice.getId());
            dbNotice.setNewsContext(notice.getNewsContext());
            dbNotice.setNewsTitle(notice.getNewsTitle());
            dbNotice.setReplyAtt(notice.getReplyAtt());
            dbNotice.setUpdateTime(new Date());
            dbNotice.setUpdateBy(currentUser.getRealname());
            dbNotice.setTemporaryState(notice.getTemporaryState());
            dbNotice.setNoticeperson(notice.getNoticeperson());
            dbNotice.setUndoState("0");
            if (notice.getUnreadnum() != null) {
                dbNotice.setUnreadnum(notice.getUnreadnum());
            }
            if (dbNotice.getSendTime() == null) {
                dbNotice.setSendTime(notice.getSendTime());
            }
            dbNotice.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticePoliceDao.update(dbNotice);
        }
        if (notice.getSysAttachmentIds() != null && notice.getSysAttachmentIds().length > 0) {
            dbSysAttachment = null;
            for (Long sysAttachmentId : notice.getSysAttachmentIds()) {
                dbSysAttachment = this.sysAttachmentDao.findById(sysAttachmentId);
                dbSysAttachment.setBusinessid(notice.getId());
                dbSysAttachment.setBusinesstype("001");
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());
                dbSysAttachment.setUpdateflag(Boolean.valueOf(true));
                this.sysAttachmentDao.update(dbSysAttachment);
            }
        }
        if (notice.getUeditorImageIds() != null && notice.getUeditorImageIds().length > 0) {
            dbSysAttachment = null;
            for (Long ueditorImageId : notice.getUeditorImageIds()) {
                dbSysAttachment = this.sysAttachmentDao.findById(ueditorImageId);
                dbSysAttachment.setBusinessid(notice.getId());
                dbSysAttachment.setBusinesstype("002");
                dbSysAttachment.setUpdateBy(currentUser.getUsername());
                dbSysAttachment.setUpdateTime(new Date());
                dbSysAttachment.setUpdateflag(Boolean.valueOf(true));
                this.sysAttachmentDao.update(dbSysAttachment);
            }
        }
        if (notice.getCompanyIds() != null && notice.getCompanyIds().length > 0) {
            int i = 0;
            NewsCompanyRelationship relationship = new NewsCompanyRelationship();
            relationship.setNewsnoticeId(notice.getId());
            relationship.setUpdateBy(currentUser.getUsername());
            relationship.setUpdateTime(new Date());
            this.newsCompanyRelationshipDao.deleteByNoticePoliceId(relationship);
            String[] stringArray = notice.getCompanyIds();
            n = stringArray.length;
            for (int ueditorImageId = 0; ueditorImageId < n; ++ueditorImageId) {
                String companyId = stringArray[ueditorImageId];
                relationship = new NewsCompanyRelationship();
                relationship.setActive(Boolean.valueOf(true));
                relationship.setCreateTime(new Date());
                relationship.setCompanyname(notice.getCompanyNames()[i]);
                relationship.setCompanyId(Long.valueOf(Long.parseLong(companyId)));
                relationship.setNewsnoticeId(notice.getId());
                relationship.setUpdateBy(currentUser.getUsername());
                relationship.setUpdateTime(new Date());
                relationship.setUpdateflag(Boolean.valueOf(true));
                this.newsCompanyRelationshipDao.save(relationship);
                ++i;
            }
        }
        if (notice.getRelationIds() != null && notice.getRelationIds().length > 0) {
            int i = 0;
            NewsnoticeRecipient recipient = new NewsnoticeRecipient();
            recipient.setNoticePoliceId(notice.getId());
            recipient.setUpdateTime(new Date());
            recipient.setUpdateBy(currentUser.getUsername());
            this.newsnoticeRecipientDao.deleteByNoticePoliceId(recipient);
            String[] stringArray = notice.getRelationIds();
            n = stringArray.length;
            for (int ueditorImageId = 0; ueditorImageId < n; ++ueditorImageId) {
                String relationId = stringArray[ueditorImageId];
                recipient = new NewsnoticeRecipient();
                recipient.setActive(Boolean.valueOf(true));
                recipient.setCreateTime(new Date());
                recipient.setRelationId(relationId);
                recipient.setType(notice.getTypes()[i]);
                recipient.setUpdateBy(currentUser.getUsername());
                recipient.setUpdateTime(new Date());
                recipient.setNoticePoliceId(notice.getId());
                recipient.setUpdateflag(Boolean.valueOf(true));
                this.newsnoticeRecipientDao.save(recipient);
                ++i;
            }
        }
        if (StringUtil.isNotEmpty((String)notice.getTemporaryState()) && notice.getTemporaryState().equals("1")) {
            NewsnoticeCompany newsnoticeCompany = null;
            for (String companyId : notice.getCompanyIds()) {
                newsnoticeCompany = new NewsnoticeCompany();
                newsnoticeCompany.setActive(Boolean.valueOf(true));
                newsnoticeCompany.setCompanyId(Long.valueOf(Long.parseLong(companyId)));
                newsnoticeCompany.setCreateTime(new Date());
                newsnoticeCompany.setNewscontext(notice.getNewsContext());
                newsnoticeCompany.setNewsnoticeid(notice.getId());
                newsnoticeCompany.setNewstitle(notice.getNewsTitle());
                newsnoticeCompany.setReadstate("0");
                newsnoticeCompany.setSendname(currentUser.getRealname());
                newsnoticeCompany.setSendorgname(currentUser.getPolice().getOrgname());
                newsnoticeCompany.setUpdateBy(currentUser.getUsername());
                newsnoticeCompany.setUpdateTime(new Date());
                newsnoticeCompany.setUpdateflag(Boolean.valueOf(true));
                newsnoticeCompany.setUndoState("0");
                newsnoticeCompany.setReplyAtt(notice.getReplyAtt());
                newsnoticeCompany.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                this.newsnoticeCompanyDao.save(newsnoticeCompany);
            }
        }
    }

    public PageResult queryTable(NewsnoticePoliceSearchDto searchDto) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        List list = this.newsnoticePoliceDao.search(searchDto);
        Long count = this.newsnoticePoliceDao.searchCount(searchDto);
        return new PageResult(Integer.valueOf(count.intValue()), (Object)list);
    }

    public void delete(Long noticeId) {
        User currentUser = this.arsUtil.getCurrentUser();
        NewsnoticePolice dbNotice = this.newsnoticePoliceDao.findById(noticeId);
        if (dbNotice != null) {
            dbNotice.setActive(Boolean.valueOf(false));
            dbNotice.setUpdateBy(currentUser.getUsername());
            dbNotice.setUpdateTime(new Date());
            this.newsnoticePoliceDao.delete(dbNotice);
        }
    }

    public void recall(Long noticeId) {
        User currentUser = this.arsUtil.getCurrentUser();
        NewsnoticePolice dbNotice = this.newsnoticePoliceDao.findById(noticeId);
        if (dbNotice != null) {
            dbNotice.setUndoState("1");
            dbNotice.setUpdateBy(currentUser.getUsername());
            dbNotice.setUpdateTime(new Date());
            dbNotice.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticePoliceDao.recall(dbNotice);
            NewsnoticeCompany newsnoticeCompany = new NewsnoticeCompany();
            newsnoticeCompany.setNewsnoticeid(noticeId);
            newsnoticeCompany.setUpdateBy(currentUser.getUsername());
            newsnoticeCompany.setUpdateTime(new Date());
            newsnoticeCompany.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticeCompanyDao.recallByNoticePoliceId(newsnoticeCompany);
        }
    }

    public NewsnoticePolice findById(Long noticeId) {
        return this.newsnoticePoliceDao.findById(noticeId);
    }

    public void batchDelete(Long[] noticeIds) {
        User currentUser = this.arsUtil.getCurrentUser();
        for (Long noticeId : noticeIds) {
            NewsnoticePolice dbNotice = this.newsnoticePoliceDao.findById(noticeId);
            if (dbNotice == null) continue;
            dbNotice.setActive(Boolean.valueOf(false));
            dbNotice.setUpdateBy(currentUser.getUsername());
            dbNotice.setUpdateTime(new Date());
            dbNotice.setUpdateflag(Boolean.valueOf(true));
            this.newsnoticePoliceDao.delete(dbNotice);
        }
    }

    public NewsnoticePolice findAllById(Long noticeId) {
        NewsnoticePolice newsnoticePolice = this.newsnoticePoliceDao.findById(noticeId);
        newsnoticePolice.setSysAttachments(this.sysAttachmentDao.findAllByBusiness(newsnoticePolice.getId().toString(), "001"));
        newsnoticePolice.setRecipients(this.newsCompanyRelationshipDao.findByNoticePoliceId(newsnoticePolice.getId()));
        newsnoticePolice.setOriginalRecipients(this.newsnoticeRecipientDao.findByNoticePoliceId(newsnoticePolice.getId()));
        if (newsnoticePolice.getTemporaryState().equals("1")) {
            if ("1".equals(newsnoticePolice.getNewsType())) {
                newsnoticePolice.setNoticeCompanys(this.newsnoticeCompanyDao.findByNoticePoliceIdForUser(newsnoticePolice.getId()));
            } else {
                newsnoticePolice.setNoticeCompanys(this.newsnoticeCompanyDao.findByNoticePoliceId(newsnoticePolice.getId()));
            }
        }
        return newsnoticePolice;
    }

    public List<NewsnoticePolice> findDSOutList(String startDate) {
        return this.newsnoticePoliceDao.searchFromInToOutForExport(startDate);
    }

    public List<NewsnoticePolice> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.newsnoticePoliceDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(NewsnoticePolice newsnoticePolice) {
        NewsnoticePolice dbnewsnoticePolice;
        newsnoticePolice.setUpdateflag(Boolean.valueOf(false));
        if (newsnoticePolice.getActive() == null) {
            newsnoticePolice.setActive(Boolean.valueOf(true));
        }
        if ((dbnewsnoticePolice = this.newsnoticePoliceDao.findById(newsnoticePolice.getId())) != null) {
            if (dbnewsnoticePolice.getActive() != newsnoticePolice.getActive() || StringUtil.isNotEmpty((String)dbnewsnoticePolice.getUndoState()) && !dbnewsnoticePolice.getUndoState().equals(newsnoticePolice.getUndoState())) {
                newsnoticePolice.setActive(dbnewsnoticePolice.getActive());
                newsnoticePolice.setUndoState(dbnewsnoticePolice.getUndoState());
                if (dbnewsnoticePolice.getUpdateflag().booleanValue()) {
                    newsnoticePolice.setUpdateflag(Boolean.valueOf(true));
                }
                this.newsnoticePoliceDao.updateForDS(newsnoticePolice);
            } else if (newsnoticePolice.getUpdateTime().getTime() > dbnewsnoticePolice.getUpdateTime().getTime()) {
                this.newsnoticePoliceDao.updateForDS(newsnoticePolice);
            }
        }
    }

    public List<ZTree> getPoliceUserTree() {
        NewsnoticePoliceSearchDto searchDto = new NewsnoticePoliceSearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setUserid(currentUser.getId());
        searchDto.setPath(currentUser.getPolice().getPath());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        List list = this.newsnoticePoliceDao.getPoliceUserTree(searchDto);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (ZTree zTree : list) {
            String[] keys;
            if (!zTree.getType().equals("1")) continue;
            for (String key : keys = zTree.getPath().split("/")) {
                if (!StringUtil.isNotEmpty((String)key)) continue;
                Integer count = (Integer)countMap.get(key);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                countMap.put(key, count);
            }
        }
        for (ZTree zTree : list) {
            zTree.setPath(null);
            if (!zTree.getType().equals("0")) continue;
            zTree.setName(zTree.getName() + "(" + countMap.get(zTree.getId()) + ")");
        }
        return list;
    }

    public void saveOrUpdateForImport(NewsnoticePolice newsnoticePolice) {
        try {
            newsnoticePolice.setUpdateflag(Boolean.valueOf(false));
            NewsnoticePolice dbNewsnoticePolice = this.newsnoticePoliceDao.findById(newsnoticePolice.getId());
            if (dbNewsnoticePolice == null) {
                newsnoticePolice.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticePolice.getUpdateTime(), (int)1));
                this.sendMsg(newsnoticePolice);
                this.newsnoticePoliceDao.saveForDS(newsnoticePolice);
            } else if (dbNewsnoticePolice.getActive() != newsnoticePolice.getActive() || StringUtil.isNotEmpty((String)newsnoticePolice.getUndoState()) && !newsnoticePolice.getUndoState().equals(dbNewsnoticePolice.getUndoState())) {
                this.delMsg(dbNewsnoticePolice);
                dbNewsnoticePolice.setActive(newsnoticePolice.getActive());
                dbNewsnoticePolice.setUndoState(newsnoticePolice.getUndoState());
                dbNewsnoticePolice.setUpdateTime(new Date());
                this.newsnoticePoliceDao.updateForDS(dbNewsnoticePolice);
            } else if (newsnoticePolice.getUpdateTime().getTime() > dbNewsnoticePolice.getUpdateTime().getTime()) {
                newsnoticePolice.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticePolice.getUpdateTime(), (int)1));
                if (!dbNewsnoticePolice.getTemporaryState().equals(newsnoticePolice.getTemporaryState())) {
                    this.sendMsg(newsnoticePolice);
                }
                this.newsnoticePoliceDao.updateForDS(newsnoticePolice);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void delMsg(NewsnoticePolice newsnoticePolice) {
        try {
            if (newsnoticePolice.getActive().booleanValue() && "0".equals(newsnoticePolice.getUndoState())) {
                SAASMessage message = new SAASMessage();
                message.setId(newsnoticePolice.getMessageIdSaaS());
                message.setMessageType("050301");
                ArrayList<SAASMessage> list = new ArrayList<SAASMessage>();
                list.add(message);
                SAASMessageDto messageDto = new SAASMessageDto();
                messageDto.setMessageJson(JSON.toJSONString(list));
                this.saasInterfaceUtil.delSaasMsg(messageDto);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u516c\u5171\u670d\u52a1\u5e73\u53f0\u6d88\u606f\u53d1\u9001\u5931\u8d25ID" + newsnoticePolice.getId());
        }
    }

    private void sendMsg(NewsnoticePolice newsnoticePolice) {
        try {
            if (newsnoticePolice.getActive().booleanValue() && "0".equals(newsnoticePolice.getUndoState())) {
                String title = newsnoticePolice.getNewsTitle();
                String content = newsnoticePolice.getNewsContext();
                List newsnoticeCompanyList = this.newsnoticeCompanyDao.findByNoticePoliceId(newsnoticePolice.getId());
                if (newsnoticeCompanyList.size() > 0) {
                    List idList = newsnoticeCompanyList.stream().map(NewsnoticeCompany::getCompanyId).collect(Collectors.toList());
                    List saaSCompanyList = this.securityCompanyDao.findUserNameByBatchId(idList);
                    saaSCompanyList.stream().map(SaaSCompany::getComId).collect(Collectors.joining(",", "", ""));
                    List sysAttachmentList = this.sysAttachmentDao.findAllByBusiness(newsnoticePolice.getId().toString(), "001");
                    SAASMessageDto messageDto = new SAASMessageDto();
                    messageDto.setTitle(title);
                    messageDto.setContent(content);
                    if (saaSCompanyList != null && saaSCompanyList.size() > 0) {
                        messageDto.setComIds(saaSCompanyList.stream().map(SaaSCompany::getComId).collect(Collectors.joining(",", "", "")));
                    }
                    StringBuffer enclosureUrl = new StringBuffer();
                    if (sysAttachmentList != null && sysAttachmentList.size() > 0) {
                        Config webHost = this.configUtils.getConfigByKey("web_host");
                        for (SysAttachment at : sysAttachmentList) {
                            if (webHost != null) {
                                enclosureUrl.append(webHost.getValue());
                            }
                            enclosureUrl.append("/sysAttachment/download.do?id=").append(at.getId()).append("||");
                            enclosureUrl.append(at.getFileName().replaceAll("||", "").replaceAll("&&", "")).append("&&");
                        }
                        enclosureUrl.deleteCharAt(enclosureUrl.length() - 1);
                        enclosureUrl.deleteCharAt(enclosureUrl.length() - 1);
                    }
                    messageDto.setEnclosureUrl(enclosureUrl.toString());
                    messageDto.setSendPer(newsnoticePolice.getSendOrgName());
                    messageDto.setNoticePerson(newsnoticePolice.getNoticeperson());
                    messageDto.setMessageType("050301");
                    messageDto.setPoliceRegionId(newsnoticePolice.getAreaCode());
                    messageDto.setIsNeedCallBackBBD("1");
                    AjaxResult result = this.saasInterfaceUtil.sendSaasMsg(messageDto);
                    if (result.isSuccessful()) {
                        newsnoticePolice.setMessageIdSaaS(result.getData().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u516c\u5171\u670d\u52a1\u5e73\u53f0\u6d88\u606f\u53d1\u9001\u5931\u8d25ID" + newsnoticePolice.getId());
        }
    }

    public void searchForPage(NewsnoticePolicePageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.newsnoticePoliceDao.searchForPage(dto, page);
    }
}

