/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dao.sb.UserBusinessTypeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.page.PoliceUserDto;
import com.bcxin.ars.dto.page.UserPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.UserRole;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.model.sb.UserBusinessType;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.impl.SecurityCompanyServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.IdNumUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.Sha1Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import com.bcxin.ars.webservice.Bajgll;
import com.bcxin.ars.webservice.ClientUtil;
import com.beust.jcommander.internal.Maps;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=User.class)
@DataSyncOutAnnotation(getClazz=User.class)
public class UserServiceImpl
extends BaseService
implements UserService {
    private static Logger logger = LoggerFactory.getLogger(SecurityCompanyServiceImpl.class);
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private UserBusinessTypeDao userBusinessTypeDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private SecurityPersonDaoAop personDaoAop;
    @Autowired
    private PoliceService policeService;
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private ConferenceAccountDao conferenceAccountDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Value(value="${personcertificate-download-folder}")
    private String tempftpFolder;
    @Value(value="${heiweiPrefixKey}")
    private String heiweiPrefixKey;

    public List<Map> searchAllCompanyUser(String lastDate, String now) {
        return this.userDao.searchAllCompanyUser(lastDate, now);
    }

    public List<User> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        List userList = this.userDao.searchForDataSynchronization(dto);
        for (User user : userList) {
            user.setUserRoles(this.userRoleDao.findByUserId(user.getId()));
        }
        return userList;
    }

    public UserSearchDto searchApproveUser(UserSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        dto.setPlatform("1");
        if (dto.getOrgid() == null && user.getOrgid() != null) {
            dto.setOrgid(user.getOrgid());
        }
        List data = this.userDao.searchApproveUser(dto);
        Long count = this.userDao.searchCountApproveUser(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public User findByUsername(String username, String platform) {
        return this.userDao.findByUsername(username, platform);
    }

    public User findByIdNum(String idNum, String platform) {
        return this.userDao.findByIdNum(idNum, platform);
    }

    public User findByUsernameForPolice(String username) {
        return this.userDao.findByUsernameForPolice(username);
    }

    public User findByUsernameStatus(String username, Boolean active) {
        return this.userDao.findByUsernameStatus(username, active);
    }

    public void delete(User user) {
        Police police;
        Config config = this.configDao.findByKey("police");
        User checkUser = this.userDao.checkUseById(user.getId());
        if (checkUser != null) {
            throw new ArsException("\u8be5\u8d26\u53f7\u5728\u4f7f\u7528\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        checkUser = this.findByIdForManager(user.getId());
        if (checkUser != null) {
            List roles = checkUser.getRoles();
            Iterator iterator = roles.iterator();
            while (iterator.hasNext()) {
                PoliceRole policeRole;
                policeRole.setUsernum((policeRole = (PoliceRole)iterator.next()).getUsernum() != null ? Long.valueOf(policeRole.getUsernum() - 1L) : null);
                policeRole.setUpdateTime(new Date());
                if (config.getValue().equals("1")) {
                    policeRole.setUpdateflag(Boolean.valueOf(true));
                }
                this.policeRoleDao.update(policeRole);
            }
        }
        if (checkUser.getOrgid() != null && (police = this.policeService.findById(checkUser.getOrgid().longValue())) != null) {
            police.setUsernum(police.getUsernum() != null ? Long.valueOf(police.getUsernum() - 1L) : null);
            if (config.getValue().equals("1")) {
                police.setUpdateflag(Boolean.valueOf(true));
            }
            this.policeService.updatenum(police);
        }
        user.setUpdateTime(new Date());
        user.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.delete(user);
    }

    public void updatePassword(User user) {
        Config config = this.configDao.findByKey("police");
        user.setPassword(user.getPassword().trim());
        User dbUser = this.userDao.findById(user.getId());
        if (Sha1Util.validatePassword((String)user.getPassword(), (String)dbUser.getPassword())) {
            throw new ArsException("\u65b0\u5bc6\u7801\u4e0d\u5e94\u8be5\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c!");
        }
        dbUser.setPassword(user.getPassword().trim());
        dbUser.setUpdateTime(new Date());
        if (this.arsUtil.getCurrentUser() != null) {
            dbUser.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        } else {
            dbUser.setUpdateBy(user.getUsername());
        }
        if (!dbUser.getInit().booleanValue()) {
            dbUser.setInitstep("001");
        }
        if (config.getValue().equals("1")) {
            dbUser.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updatePassword(dbUser);
    }

    public void updatePasswordBypolice(User user) {
        Config config = this.configDao.findByKey("police");
        user.setUpdateTime(new Date());
        if (this.arsUtil.getCurrentUser() != null) {
            user.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        } else {
            user.setUpdateBy(user.getUsername());
        }
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updatePassword(user);
    }

    public void updateLoginState(User user) {
        Config config = this.configDao.findByKey("police");
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updateLoginState(user);
    }

    private Long searchCountApproveUser(User user) {
        UserSearchDto userSearchDto = new UserSearchDto();
        if (null != user.getCodeNo() && !"".equals(user.getCodeNo())) {
            userSearchDto.setCodeNo(user.getCodeNo());
            userSearchDto.setUserid(user.getId());
            return this.userDao.searchCountByCodeNo(userSearchDto);
        }
        return 0L;
    }

    public void saveOrUpdate(User user, String platform) {
        User existUser;
        User currentUser = this.arsUtil.getCurrentUser();
        if (this.searchCountApproveUser(user) >= 1L) {
            throw new ArsException("\u8b66\u53f7\u5df2\u5b58\u5728\uff01");
        }
        Config config = this.configDao.findByKey("police");
        user.setUsername(user.getUsername().trim().replaceAll(" ", ""));
        if (StringUtils.isEmpty((Object)user.getPhoto()) && user.getPlatform() == 1) {
            user.setPhoto("assets/images/defaultHead/police.png");
        }
        if (user.getId() == null) {
            existUser = this.userDao.findByUsername(user.getUsername(), platform);
            if (existUser != null) {
                if ("1".equals(platform)) {
                    throw new ArsException("\u8b66\u53f7\u5df2\u5b58\u5728\uff01");
                }
                throw new ArsException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
            }
            if (StringUtil.isNotEmpty((String)user.getPhone())) {
                user.setPhone(user.getPhone().trim());
            }
            if (!StringUtil.isNotEmpty((String)user.getPassword())) {
                user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
            }
            if (user.getRealname() != null) {
                user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
            }
            user.setNativeCode(this.arsUtil.getCurrentNatvie());
            user.setInit(Boolean.valueOf(false));
            user.setActive(Boolean.valueOf(true));
            user.setCreateTime(new Date());
            user.setUpdateTime(user.getCreateTime());
            if (currentUser != null) {
                user.setUpdateBy(currentUser.getUsername());
            }
            user.setLoginNum(Integer.valueOf(0));
            if (config.getValue().equals("1")) {
                user.setUpdateflag(Boolean.valueOf(true));
            }
            user.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            this.userDao.save(user);
            if (user.getOrgid() != null) {
                Long count = this.userDao.findCountByorgid(user.getOrgid());
                Police org = this.policeService.findById(user.getOrgid().longValue());
                if (org != null) {
                    org.setUsernum(count);
                    if (config.getValue().equals("1")) {
                        org.setUpdateflag(Boolean.valueOf(true));
                    }
                    this.policeService.updatenum(org);
                    new Thread(() -> {
                        try {
                            Bajgll bajgll = new Bajgll();
                            if (StringUtil.isNotEmpty((String)user.getIdNumber())) {
                                bajgll.setXm(user.getRealname());
                                String sex = IdNumUtil.getGenderByIdCard((String)user.getIdNumber());
                                if (StringUtil.isNotEmpty((String)sex)) {
                                    bajgll.setXb(sex.equals("\u7537") ? "1" : "0");
                                }
                                bajgll.setJgjgbh(org.getCode());
                                bajgll.setJgjgmc(org.getOrgname());
                                bajgll.setJgjgdz(org.getAreacode());
                                bajgll.setJgjgxz(org.getAddress());
                                bajgll.setJgzt("1");
                                bajgll.setSfzh(user.getIdNumber());
                                bajgll.setSj(user.getPhone());
                                this.clientUtil.send("xxba_bajgll", (Object)bajgll);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        } else {
            existUser = this.userDao.findByUsernameAndId(user);
            if (existUser != null) {
                if ("1".equals(platform)) {
                    throw new ArsException("\u8b66\u53f7\u5df2\u5b58\u5728\uff01");
                }
                throw new ArsException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
            }
            User dbUser = this.userDao.findById(user.getId());
            if (dbUser != null) {
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy(currentUser.getUsername());
                if (user.getActive() != null && user.getActive().booleanValue()) {
                    dbUser.setActive(Boolean.valueOf(true));
                }
                if (user.getPoliceman() != null) {
                    dbUser.setPoliceman(user.getPoliceman());
                }
                if (user.getInit() != null && user.getInit().booleanValue()) {
                    dbUser.setInit(Boolean.valueOf(true));
                }
                if (!StringUtils.isEmpty((Object)user.getRealname())) {
                    dbUser.setRealname(user.getRealname().trim().replaceAll(" ", ""));
                }
                if (!StringUtils.isEmpty((Object)user.getPhone())) {
                    dbUser.setPhone(user.getPhone().trim());
                }
                if (!StringUtils.isEmpty((Object)user.getPhoto())) {
                    dbUser.setPhoto(user.getPhoto());
                }
                if (!StringUtils.isEmpty((Object)user.getCodeNo())) {
                    dbUser.setCodeNo(user.getCodeNo());
                }
                if (!StringUtils.isEmpty((Object)user.getOrgName())) {
                    dbUser.setOrgName(user.getOrgName());
                }
                if (!StringUtils.isEmpty((Object)user.getRoleName())) {
                    dbUser.setRoleName(user.getRoleName());
                }
                if (user.getOrgid() != null) {
                    dbUser.setOrgid(user.getOrgid());
                }
                if (user.getLoginNum() != null) {
                    dbUser.setLoginNum(user.getLoginNum());
                }
                if (!StringUtils.isEmpty((Object)user.getLoginDate())) {
                    dbUser.setLoginDate(user.getLoginDate());
                }
                if (!StringUtils.isEmpty((Object)user.getIsAdmin())) {
                    dbUser.setIsAdmin(user.getIsAdmin());
                }
                dbUser.setIdNumber(user.getIdNumber());
                if (!StringUtils.isEmpty((Object)user.getUsername())) {
                    dbUser.setUsername(user.getUsername());
                }
                if (config.getValue().equals("1")) {
                    dbUser.setUpdateflag(Boolean.valueOf(true));
                }
                this.userDaoAop.update(dbUser);
            }
        }
        switch (user.getPlatform()) {
            case 1: {
                this.userRoleDao.deleteByUserIdAndRoleId(user.getId().longValue(), "2");
                if (user.getRoles() != null && user.getRoles().size() > 0) {
                    UserRole userRole = null;
                    for (PoliceRole policeRole : user.getRoles()) {
                        userRole = new UserRole();
                        userRole.setActive(Boolean.valueOf(true));
                        userRole.setCreateTime(new Date());
                        userRole.setNativeCode(this.arsUtil.getCurrentNatvie());
                        userRole.setRoleid(policeRole.getId());
                        userRole.setUserid(user.getId());
                        userRole.setUpdateBy(currentUser.getUsername());
                        userRole.setUpdateTime(new Date());
                        userRole.setRoleType("2");
                        this.userRoleDao.save(userRole);
                        Long count = this.userDao.findCountByroleid(policeRole.getId());
                        PoliceRole dbRole = this.policeRoleDao.findById(policeRole.getId().longValue());
                        if (dbRole == null) continue;
                        dbRole.setUsernum(count);
                        dbRole.setUpdateTime(new Date());
                        if (config.getValue().equals("1")) {
                            dbRole.setUpdateflag(Boolean.valueOf(true));
                        }
                        this.policeRoleDao.update(dbRole);
                    }
                }
                this.userBusinessTypeDao.delByUserId(user.getId());
                if (user.getUserBusinessTypeList() == null || user.getUserBusinessTypeList().size() <= 0) break;
                for (UserBusinessType temp : user.getUserBusinessTypeList()) {
                    temp.setActive(Boolean.valueOf(true));
                    temp.setCreateTime(new Date());
                    temp.setUpdateBy(currentUser.getUsername());
                    temp.setUpdateTime(new Date());
                    temp.setUserId(user.getId());
                    this.userBusinessTypeDao.save(temp);
                }
                break;
            }
        }
    }

    public UserSearchDto search(UserSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        dto.setPlatform("1");
        if (StringUtil.isEmpty((String)dto.getOrgIds()) && user.getOrgid() != null) {
            dto.setOrgIds(user.getOrgid() + "");
        }
        List data = this.userDao.search(dto);
        Long count = this.userDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public User findById(Long userid) {
        return this.userDao.findById(userid);
    }

    public User findByComId(Long comId) {
        return this.userDao.findByComId(comId);
    }

    public User findByIdForManager(Long userid) {
        User result = this.userDao.findByIdForManager(userid);
        result.setUserBusinessTypeList(this.userBusinessTypeDao.findByUserId(userid));
        return result;
    }

    public void saveOrUpdateForDS(User user) {
        block6: {
            User dbUser;
            block7: {
                block5: {
                    dbUser = this.findById(user.getId());
                    if (user.getActive() == null) {
                        user.setActive(Boolean.valueOf(true));
                    }
                    if (user.getActive().booleanValue()) break block5;
                    this.userDaoAop.delete(user);
                    break block6;
                }
                if (dbUser != null) break block7;
                this.userDao.saveForDS(user);
                List userRoles = user.getUserRoles();
                this.deleteByUserIdAndRoleId(user);
                if (userRoles == null) break block6;
                for (UserRole userRole : userRoles) {
                    userRole.setUserid(user.getId());
                    this.userRoleDao.save(userRole);
                }
                break block6;
            }
            if (user.getUpdateTime().getTime() > dbUser.getUpdateTime().getTime()) {
                this.userDaoAop.update(user);
                List userRoles = user.getUserRoles();
                this.deleteByUserIdAndRoleId(user);
                if (userRoles != null) {
                    for (UserRole userRole : userRoles) {
                        userRole.setUserid(user.getId());
                        this.userRoleDao.save(userRole);
                    }
                }
            }
        }
    }

    public List<User> findAll() {
        return this.userDao.findAll();
    }

    public void saveOrUpdateCompanyUserForSAAS(User user) {
        User currentUser = this.arsUtil.getCurrentUser();
        user.setUsername(user.getUsername().trim().replaceAll(" ", ""));
        if (StringUtils.isEmpty((Object)user.getPhoto())) {
            if (user.getPlatform() == 1) {
                user.setPhoto("assets/images/defaultHead/police.png");
            }
        } else {
            user.setPhoto(this.getPhotoPath(user.getPhoto()));
        }
        if (user.getRealname() != null) {
            user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
        }
        user.setPhone(user.getPhone().trim());
        user.setUpdateTime(new Date());
        if (currentUser != null) {
            user.setUpdateBy(currentUser.getUsername());
        } else {
            user.setUpdateBy(user.getUsername());
        }
        if (null != this.arsUtil.getCurrentNatvie()) {
            user.setNativeCode(this.arsUtil.getCurrentNatvie());
        }
        if (user.getId() == null) {
            User existUser = this.userDao.findByUsername(user.getUsername(), user.getPlatform().toString());
            if (existUser != null && 2 != user.getPlatform()) {
                throw new ArsException("\u8eab\u4efd\u8bc1\u53f7\u6216\u8005\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728\uff01");
            }
            if (!StringUtil.isNotEmpty((String)user.getPassword())) {
                user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
            }
            user.setInit(Boolean.valueOf(false));
            user.setActive(Boolean.valueOf(true));
            user.setCreateTime(new Date());
            user.setLoginNum(Integer.valueOf(0));
            user.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            this.userDao.save(user);
        } else {
            User existUser = this.userDao.findByUsernameAndId(user);
            if (existUser != null && user.getId().equals(existUser.getId())) {
                throw new ArsException("\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
            }
            User dbUser = this.userDao.findById(user.getId());
            if (dbUser != null) {
                BeanUtils.copyPropertiesIgnore((Object)user, (Object)dbUser, (Boolean)true);
                this.userDaoAop.update(dbUser);
            }
        }
    }

    public void saveOrUpdateCompanyUser(User user, String platform) {
        Config config = this.configDao.findByKey("police");
        User currentUser = this.arsUtil.getCurrentUser();
        user.setUsername(user.getUsername().trim().replaceAll(" ", ""));
        if (StringUtils.isEmpty((Object)user.getPhoto()) && user.getPlatform() == 1) {
            user.setPhoto("assets/images/defaultHead/police.png");
        }
        if (user.getId() == null) {
            User existUser = this.userDao.findByUsername(user.getUsername(), platform);
            if (existUser != null) {
                throw new ArsException("\u8eab\u4efd\u8bc1\u53f7\u6216\u8005\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728\uff01");
            }
            if (!StringUtil.isNotEmpty((String)user.getPassword())) {
                user.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
            }
            if (user.getRealname() != null) {
                user.setRealname(user.getRealname().trim().replaceAll(" ", ""));
            }
            if (StringUtil.isNotEmpty((String)user.getPhone())) {
                user.setPhone(user.getPhone().trim());
            }
            user.setNativeCode(this.arsUtil.getCurrentNatvie());
            user.setInit(Boolean.valueOf(false));
            user.setActive(Boolean.valueOf(true));
            user.setCreateTime(new Date());
            user.setUpdateTime(user.getCreateTime());
            if (currentUser != null) {
                user.setUpdateBy(currentUser.getUsername());
            } else {
                user.setUpdateBy(user.getUsername());
            }
            user.setLoginNum(Integer.valueOf(0));
            if (config.getValue().equals("1")) {
                user.setUpdateflag(Boolean.valueOf(true));
            }
            user.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            this.userDao.save(user);
            if (user.getOrgid() != null) {
                Long count = this.userDao.findCountByorgid(user.getOrgid());
                Police org = this.policeService.findById(user.getOrgid().longValue());
                if (org != null) {
                    org.setUsernum(count);
                    if (config.getValue().equals("1")) {
                        org.setUpdateflag(Boolean.valueOf(true));
                    }
                    this.policeService.updatenum(org);
                    new Thread(() -> {
                        try {
                            String[] srccol = new String[]{"realname", "phone", "idNumber"};
                            String[] desccol = new String[]{"xm", "sj", "sfzh"};
                            String[] key = new String[]{"jgzt", "bz1", "jgjgbh", "jgjgmc", "jgjgdz", "jgjgxz"};
                            String[] value = new String[]{"1", "\u8eab\u4efd\u8bc1", org.getCode(), org.getOrgname(), org.getArea(), org.getAddress()};
                            Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)user, (Object)new Bajgll(), (String[])key, (String[])value);
                            Bajgll bajgll = (Bajgll)desc;
                            this.clientUtil.send("xxba_bajgll", (Object)bajgll);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        } else {
            User existUser = this.userDao.findByUsernameAndId(user);
            if (existUser != null && user.getId().equals(existUser.getId())) {
                throw new ArsException("\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
            }
            User dbUser = this.userDao.findById(user.getId());
            String dbphone = dbUser.getPhone();
            if (dbUser != null) {
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy(currentUser.getUsername());
                if (user.getActive() != null && user.getActive().booleanValue()) {
                    dbUser.setActive(Boolean.valueOf(true));
                }
                if (user.getPoliceman() != null) {
                    dbUser.setPoliceman(user.getPoliceman());
                }
                if (user.getInit() != null && user.getInit().booleanValue()) {
                    dbUser.setInit(Boolean.valueOf(true));
                }
                if (!StringUtils.isEmpty((Object)user.getRealname())) {
                    dbUser.setRealname(user.getRealname().trim().replaceAll(" ", ""));
                }
                if (!StringUtils.isEmpty((Object)user.getPhone())) {
                    dbUser.setPhone(user.getPhone().trim());
                }
                if (!StringUtils.isEmpty((Object)user.getPhoto())) {
                    dbUser.setPhoto(user.getPhoto());
                }
                if (!StringUtils.isEmpty((Object)user.getCodeNo())) {
                    dbUser.setCodeNo(user.getCodeNo());
                }
                if (!StringUtils.isEmpty((Object)user.getOrgName())) {
                    dbUser.setOrgName(user.getOrgName());
                }
                if (!StringUtils.isEmpty((Object)user.getRoleName())) {
                    dbUser.setRoleName(user.getRoleName());
                }
                if (user.getOrgid() != null) {
                    dbUser.setOrgid(user.getOrgid());
                }
                if (user.getLoginNum() != null) {
                    dbUser.setLoginNum(user.getLoginNum());
                }
                if (user.getUpdateflag() != null && user.getUpdateflag().booleanValue()) {
                    dbUser.setUpdateflag(user.getUpdateflag());
                }
                if (!StringUtils.isEmpty((Object)user.getLoginDate())) {
                    dbUser.setLoginDate(user.getLoginDate());
                }
                if (!StringUtils.isEmpty((Object)user.getIdNumber())) {
                    dbUser.setIdNumber(user.getIdNumber());
                }
                if (config.getValue().equals("1")) {
                    dbUser.setUpdateflag(Boolean.valueOf(true));
                }
                if (!StringUtils.isEmpty((Object)user.getUsername())) {
                    dbUser.setUsername(user.getUsername());
                }
                this.userDaoAop.update(dbUser);
            }
        }
    }

    private void sentToBTK(User user) {
        Config config = this.configDao.findByKey("police");
        if (config != null && config.getValue() != null && !"1".equals(config.getValue())) {
            LogMessage logMessage = new LogMessage();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("phone", user.getUsername());
            map.put("pwd", user.getPhone());
            dataMap.put("data", JSON.toJSONString(map));
            logMessage.setLogger_title("\u767e\u8bfe\u5802\u4fee\u6539\u624b\u673a\u53f7\u540c\u6b65");
            String message = "\u4fee\u6539\u624b\u673a\u53f7\u540c\u6b65:";
            logMessage.setCreateTime(new Date());
            try {
                Config configURL = this.configDao.findByKey("bkt_data_url");
                if (configURL != null && configURL.getValue() != null) {
                    String url = configURL.getValue() + Constants.BTK_UPDPWD;
                    message = "\u8bbf\u95ee\u5730\u5740" + url + "|";
                    String btkRtn = HttpClientUtils.doPost((String)url, dataMap, (String)"utf-8");
                    message = message + message + "\u8fd4\u56de\u7ed3\u679c\uff1a" + btkRtn + "|";
                    if (btkRtn != null) {
                        JSONObject jsonObject = JSONObject.parseObject((String)btkRtn);
                        String retType = jsonObject.get((Object)"retType").toString();
                        String data = jsonObject.get((Object)"data").toString();
                        if (!StringUtils.isEmpty((Object)retType) && "1".equals(retType)) {
                            message = message + message + "\u540c\u6b65\u6210\u529f";
                            logger.info("\u767e\u8bfe\u5802\u4fee\u6539\u624b\u673a\u53f7\u540c\u6b65\u6210\u529f");
                        } else {
                            message = message + message + "\u540c\u6b65\u5931\u8d25";
                            logger.info("\u767e\u8bfe\u5802\u4fee\u6539\u624b\u673a\u53f7\u540c\u6b65\u5931\u8d25");
                        }
                        if (!StringUtils.isEmpty((Object)data)) {
                            message = message + message + data;
                            logMessage.setLogger_context(message);
                            this.logMessageDao.save(logMessage);
                        }
                    }
                }
            }
            catch (Exception e) {
                logMessage.setLogger_context("\u629b\u51fa\u5f02\u5e38\uff1a" + e.toString() + "\u8fc7\u7a0b\u4fe1\u606f\uff1a" + message);
                this.logMessageDao.save(logMessage);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateInitstep(User user) {
        Config config = this.configDao.findByKey("police");
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        user.setUpdateTime(new Date());
        this.userDaoAop.updateInitstep(user);
    }

    public void updateXjdUserId(User user) {
        Config config = this.configDao.findByKey("police");
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updateXjdUserId(user);
    }

    public List<User> findXjdUserList() {
        return this.userDao.findXjdUserList();
    }

    public void updateFlag(User user) {
        Config config = this.configDao.findByKey("police");
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updateFlag(user);
    }

    public void updateAuthMark(User user) {
        Config config = this.configDao.findByKey("police");
        if (config.getValue().equals("1")) {
            user.setUpdateflag(Boolean.valueOf(true));
        }
        this.userDaoAop.updateAuthMark(user);
    }

    public List<ReportData> findByAreaReport(ReportDataSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        return this.userDao.findByAreaReport(searchDto);
    }

    private void writeTxtFile(String readStr, String type) {
        try {
            String basePath = this.tempftpFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    public void autoExportUser() {
        List userList = this.userDao.searchForExport();
        if (userList != null && userList.size() > 0) {
            try {
                for (User u : userList) {
                    u.setUpdateflag(Boolean.valueOf(false));
                    String userStr = JSONArray.toJSONString((Object)u);
                    System.out.println(userStr);
                    String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])userStr.getBytes(), (String)Constants.APPROVAL_KEY));
                    this.writeTxtFile(content, "user");
                    List userRoleList = this.userRoleDao.findByUserId(u.getId());
                    String userRoleListStr = JSONArray.toJSONString((Object)userRoleList);
                    String userRoleListcontent = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])userRoleListStr.getBytes(), (String)Constants.APPROVAL_KEY));
                    this.writeTxtFile(userRoleListcontent, "userrole");
                    this.userDaoAop.updateExportFlag(u);
                }
            }
            catch (Exception e) {
                System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
        }
    }

    public void deleteByUserIdAndRoleId(User user) {
        String roleType = "";
        switch (user.getPlatform()) {
            case 1: {
                roleType = "2";
                break;
            }
            case 3: {
                roleType = "1";
                break;
            }
        }
        if (StringUtil.isNotEmpty((String)roleType)) {
            this.userRoleDao.deleteByUserIdAndRoleId(user.getId().longValue(), roleType);
        }
    }

    @Deprecated
    public void saveOrUpdateForImport(User user) {
        block6: {
            User dbUser;
            block5: {
                user.setUpdateflag(Boolean.valueOf(false));
                if (user.getActive() == null) {
                    user.setActive(Boolean.valueOf(true));
                }
                if ((dbUser = this.findById(user.getId())) != null) break block5;
                user.setUpdateTime(new Date());
                this.userDao.save(user);
                List userRoles = user.getUserRoles();
                this.deleteByUserIdAndRoleId(user);
                if (userRoles == null) break block6;
                for (UserRole userRole : userRoles) {
                    userRole.setUserid(user.getId());
                    this.userRoleDao.save(userRole);
                }
                break block6;
            }
            if (user.getUpdateTime().getTime() > dbUser.getUpdateTime().getTime()) {
                user.setUpdateTime(new Date());
                this.userDaoAop.update(user);
                List userRoles = user.getUserRoles();
                this.deleteByUserIdAndRoleId(user);
                if (userRoles != null) {
                    for (UserRole userRole : userRoles) {
                        userRole.setUserid(user.getId());
                        this.userRoleDao.save(userRole);
                    }
                }
            }
        }
    }

    public User findByPhone(String phone) {
        return this.userDao.findByPhone(phone);
    }

    public User findByUsernameAndPlatform(String username) {
        return this.userDao.findByUsernameAndPlatform(username);
    }

    public Boolean checkRole(User user, Object roleId) {
        List roles = user.getRoles();
        if (roles != null && roles.size() > 0 && roleId != null) {
            for (PoliceRole role : roles) {
                if (!role.getId().toString().equals(roleId.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public UserSearchDto searchAccount(UserSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        List data = this.userDao.search(dto);
        Long count = this.userDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public List<User> findDSOutList(String startDate) {
        return this.userDao.searchFromInToOutForExport(startDate);
    }

    public void importBatch(List<User> list) {
        List dbList = this.userDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (User detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                List userRoles = detail.getUserRoles();
                this.deleteByUserIdAndRoleId(detail);
                this.userRoleDao.deleteByUserId(detail.getId());
                if (userRoles == null || userRoles.size() <= 0) continue;
                this.userRoleDao.batchSave(userRoles);
            }
            this.userDaoAop.saveBatch(list);
        }
    }

    public void searchForPage(UserPageSearchDto dto, AjaxPageResponse<PoliceUserDto> ajaxPageResponse) {
        this.userDao.searchForPage(dto, ajaxPageResponse);
    }

    public void addUserConference(User dto) {
        if (dto.getId() == null) {
            throw new ArsException("\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User currentUser = this.arsUtil.getCurrentUser();
        User user = this.userDao.findById(dto.getId());
        ConferenceAccount dbConferenceAccount = this.conferenceAccountDao.selectByUserId(dto.getId());
        if (dbConferenceAccount != null) {
            throw new ArsException("\u5df2\u5f00\u901a\u7528\u6237\u4e0d\u9700\u8981\u518d\u5f00\u901a");
        }
        String accessToken = this.arsUtil.getHuaweiMeetAccessToken(this.configUtils.getValueByKey("HeiweiconferenceAccount"), this.configUtils.getValueByKey("HeiweiconferencePassword"), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
        String account = this.heiweiPrefixKey + user.getId();
        String pwd = this.heiweiPrefixKey + "_pwd" + user.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", user.getRealname());
        map.put("account", account);
        map.put("pwd", pwd);
        map.put("phone", user.getPhone());
        map.put("sendNotify", "0");
        map.put("country", "chinaPR");
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/member";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Basic " + authorization);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)"POST", headMap, (String)JSON.toJSONString(map), null);
        RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
        if (response.getHttpCode() != 200) {
            logger.error(response.getEntity());
            throw new ArsException("\u5f00\u901a\u5931\u8d25");
        }
        Map data = (Map)JSON.parseObject((String)response.getEntity(), Map.class);
        user.setHuaweiUserId(data.get("id").toString());
        user.setHuaweiSipName(data.get("sipNum").toString());
        ConferenceAccount conferenceAccount = new ConferenceAccount();
        conferenceAccount.setActive(Boolean.valueOf(true));
        conferenceAccount.setCreateBy(currentUser.getUsername());
        conferenceAccount.setCreateTime(new Date());
        conferenceAccount.setUpdateTime(new Date());
        conferenceAccount.setUserid(user.getId());
        conferenceAccount.setAccount(account);
        conferenceAccount.setPassword(pwd);
        conferenceAccount.setHuaweiUserId(user.getHuaweiUserId());
        conferenceAccount.setHuaweiSipName(user.getHuaweiSipName());
        this.conferenceAccountDao.insert(conferenceAccount);
    }

    public void delUserConference(User dto) {
        if (StringUtils.isEmpty((Object)dto.getId())) {
            throw new ArsException("\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ConferenceAccount conferenceAccount = this.conferenceAccountDao.selectByUserId(dto.getId());
        if (conferenceAccount == null) {
            return;
        }
        String accessToken = this.arsUtil.getHuaweiMeetAccessToken(this.configUtils.getValueByKey("HeiweiconferenceAccount"), this.configUtils.getValueByKey("HeiweiconferencePassword"), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
        ArrayList<String> huaweiUserNameList = new ArrayList<String>();
        huaweiUserNameList.add(conferenceAccount.getAccount());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Basic " + authorization);
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/member/delete";
        RestRequest restRequest = HttpBuildUtil.buildRestRequest((String)"POST", headMap, (String)JSON.toJSONString(huaweiUserNameList), null);
        RestResponse response = HttpBuildUtil.sendMsg((String)url, (RestRequest)restRequest);
        if (response.getHttpCode() != 200) {
            throw new ArsException("\u5173\u95ed\u5931\u8d25");
        }
        conferenceAccount.setUpdateTime(new Date());
        conferenceAccount.setActive(Boolean.valueOf(false));
        this.conferenceAccountDao.updateByUserId(conferenceAccount);
    }

    public void updateConferenceState(User user) {
        if ("1".equals(user.getConferenceState())) {
            this.addUserConference(user);
        } else {
            this.delUserConference(user);
        }
        this.userDaoAop.updateConferenceState(user);
    }

    public void setDateView(User user) {
        String areaCode = user.getPolice().getAreacode();
        if (areaCode.endsWith("0000")) {
            areaCode = areaCode.substring(0, 2) + "____";
        } else if (areaCode.endsWith("00")) {
            areaCode = areaCode.substring(0, 4) + "__";
        }
        Map param = Maps.newHashMap();
        param.put("viewCode", this.configUtils.getValueByKey("BBD_RYTS"));
        param.put("areaCode", "'" + areaCode + "'");
        user.setPersonDataURL(JwtUtil.createJWT((Map)param));
        param.put("viewCode", this.configUtils.getValueByKey("BBD_QYTS"));
        user.setCompanyDataURL(JwtUtil.createJWT((Map)param));
        param.put("viewCode", this.configUtils.getValueByKey("BBD_JGTSYJ"));
        user.setPoliceDataURL(JwtUtil.createJWT((Map)param));
    }

    public User findGSAndZRRByUsername(String username) {
        User user = this.userDao.findByUsername(username, "2");
        if (StringUtils.isEmpty((Object)user)) {
            user = this.userDao.findByUsername(username, "4");
        }
        return user;
    }
}

