/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.PersonBlackListDao;
import com.bcxin.ars.dto.PerBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBlackList;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.PersonBlackListService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DataSyncOutAnnotation(getClazz=PersonBlackList.class, getImportType=ImportType.BATCH)
public class PersonBlackListServiceImpl
implements PersonBlackListService {
    @Autowired
    private PersonBlackListDao personBlackListDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;

    public PersonBlackList findById(Long id) {
        return this.personBlackListDao.findById(id);
    }

    public void update(PersonBlackList detail) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (detail.getId() == null) {
            detail.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            detail.setCreateTime(new Date());
            detail.setActive(Boolean.valueOf(true));
            detail.setAreaCode(currentUser.getPolice().getAreacode());
        } else {
            PersonBlackList dbPersonBlackList = this.personBlackListDao.findById(detail.getId());
            BeanUtils.copyPropertiesIgnore((Object)detail, (Object)dbPersonBlackList, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPersonBlackList, (Object)detail, (Boolean)true);
        }
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUser.getUsername());
        detail.setUpdateflag(Boolean.valueOf(true));
        this.personBlackListDao.save(detail);
    }

    public void delete(PersonBlackList detail) {
        User currentUser = this.arsUtil.getCurrentUser();
        detail.setUpdateflag(Boolean.valueOf(true));
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUser.getUsername());
        this.personBlackListDao.delete(detail);
    }

    public List<PersonBlackList> searchForPage(PersonBlackListPageSearchDto dto, AjaxPageResponse<PersonBlackListDto> ajaxPageResponse) {
        return this.personBlackListDao.searchForPage(dto, ajaxPageResponse);
    }

    public List<PersonBlackList> findByBatchId(List<PersonBlackList> list) {
        return this.personBlackListDao.findByBatchId(list);
    }

    public void saveBatch(List<PersonBlackList> list) {
        List dbList = this.personBlackListDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PersonBlackList detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception exception) {}
            }
            this.personBlackListDao.saveBatch(list);
        }
    }

    public List<PersonBlackList> findDSOutList(String startDate) {
        return this.personBlackListDao.findDSOutList(startDate);
    }

    public void importBatch(List<PersonBlackList> list) {
        List dbList = this.personBlackListDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PersonBlackList personBlackList : list) {
                personBlackList.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    personBlackList.setUpdateTime(DateUtil.dateAdd((int)6, (Date)personBlackList.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.personBlackListDao.saveBatch(list);
        }
    }

    public List<PerBlackListDto> findBlackPersonList(Date startTime, Date endTime) {
        Config provinceConfig = this.configUtils.getConfigByKey("current_province");
        Integer province = Integer.parseInt(provinceConfig.getValue());
        List perBlackListDtoList = this.personBlackListDao.selectBlackByUpdateTime(startTime, endTime);
        perBlackListDtoList.forEach(perBlackListDto -> {
            perBlackListDto.setProvince(province);
            perBlackListDto.setIsDelete("0");
        });
        return perBlackListDtoList;
    }
}

