/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.DataAuthDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dto.DataAuthSearchDto;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DataAuthService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataAuthServiceImpl
implements DataAuthService {
    @Autowired
    private DataAuthDao dataAuthDao;
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private ArsUtil arsUtil;

    public DataAuth findById(long id) {
        return this.dataAuthDao.findById(id);
    }

    public void saveOrUpdate(DataAuth dataAuth) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (dataAuth.getId() == null) {
            dataAuth.setActive(Boolean.valueOf(true));
            dataAuth.setCreateTime(new Date());
            dataAuth.setUpdateTime(new Date());
            dataAuth.setUpdateBy(currentUser.getUsername());
            this.dataAuthDao.save(dataAuth);
        } else {
            DataAuth dbDataAuth = this.dataAuthDao.findById(dataAuth.getId().longValue());
            dbDataAuth.setUpdateBy(currentUser.getUsername());
            dbDataAuth.setUpdateTime(new Date());
            dbDataAuth.setRoleid(dataAuth.getRoleid());
            dbDataAuth.setOrgid(dataAuth.getOrgid());
            this.dataAuthDao.update(dbDataAuth);
        }
    }

    public DataAuthSearchDto search(DataAuthSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        List list = this.dataAuthDao.search(dto);
        Long count = this.dataAuthDao.searchCount(dto);
        dto.setData(list);
        dto.setTotalCount(count);
        return dto;
    }

    public void delete(DataAuth dataAuth) {
        User currentUser = this.arsUtil.getCurrentUser();
        dataAuth.setUpdateBy(currentUser.getUsername());
        dataAuth.setUpdateTime(new Date());
        this.dataAuthDao.delete(dataAuth);
    }

    public List<DataAuth> findByOrgId(Long orgid) {
        return this.dataAuthDao.findByOrgId(orgid);
    }

    public List<DataAuth> findByRoleId(Long roleid) {
        return this.dataAuthDao.findByRoleId(roleid);
    }

    public void saveOrUpdate(Long roleid, String orgIds) {
        this.dataAuthDao.deleteByRole(roleid);
        for (String orgid : orgIds.split(",")) {
            if (!StringUtil.isNotEmpty((String)orgid)) continue;
            DataAuth auth = new DataAuth();
            auth.setRoleid(roleid);
            auth.setOrgid(Long.valueOf(Long.parseLong(orgid)));
            this.saveOrUpdate(auth);
        }
        PoliceRole policeRole = this.policeRoleDao.findById(roleid.longValue());
        policeRole.setDatarole("1");
        policeRole.setUpdateTime(new Date());
        this.policeRoleDao.update(policeRole);
    }

    public List<DataAuth> findAll() {
        return this.dataAuthDao.findAll();
    }

    public void saveOrUpdateForDS(DataAuth dataAuth) {
        DataAuth dbDataAuth = this.dataAuthDao.findByRoleIdAndOrgId(dataAuth.getRoleid(), dataAuth.getOrgid());
        if (dbDataAuth == null) {
            this.dataAuthDao.save(dataAuth);
        }
    }
}

