/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gen.impl;

import com.bcxin.ars.dao.gen.GenTableColumnDao;
import com.bcxin.ars.dao.gen.GenTableDao;
import com.bcxin.ars.dao.sys.ModuleMenuDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.GenTablePageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.model.gen.GenTableColumn;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.service.gen.GenTableService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.gen.GenUtils;
import com.bcxin.ars.service.util.gen.VelocityInitializer;
import com.bcxin.ars.service.util.gen.VelocityUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GenTableServiceImpl
implements GenTableService {
    Logger logger = LoggerFactory.getLogger(GenTableServiceImpl.class);
    @Autowired
    private GenTableDao genTableDao;
    @Autowired
    private ModuleMenuDao moduleMenuDao;
    @Autowired
    private GenTableColumnDao genTableColumnDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(GenTable genTable) {
        User currentUser = this.arsUtil.getCurrentUser();
        genTable.setUpdateTime(new Date());
        genTable.setUpdateBy(currentUser.getUsername());
        return this.genTableDao.delete(genTable);
    }

    public int save(GenTable genTable) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (genTable.getId() == null) {
            genTable.setCreateTime(new Date());
        } else {
            GenTable dbGenTable = this.genTableDao.findById(genTable.getId());
            BeanUtils.copyPropertiesIgnore((Object)genTable, (Object)dbGenTable, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbGenTable, (Object)genTable, (Boolean)false);
        }
        List dbColumnList = this.genTableColumnDao.findByBatchId(genTable.getColumns());
        Map columnMap = dbColumnList.stream().collect(Collectors.toMap(GenTableColumn::getColumnId, Function.identity()));
        for (GenTableColumn genTableColumn : genTable.getColumns()) {
            genTableColumn.setUpdateBy(currentUser.getUsername());
            genTableColumn.setUpdateTime(new Date());
            GenTableColumn dbGenTableColumn = (GenTableColumn)columnMap.get(genTableColumn.getColumnId());
            genTableColumn.setCreateTime(dbGenTableColumn.getCreateTime());
            genTableColumn.setCreateBy(dbGenTableColumn.getCreateBy());
            genTableColumn.setTableId(dbGenTableColumn.getTableId());
            genTableColumn.setColumnName(dbGenTableColumn.getColumnName());
            genTableColumn.setColumnType(dbGenTableColumn.getColumnType());
            genTableColumn.setIsPk(dbGenTableColumn.getIsPk());
            genTableColumn.setIsIncrement(dbGenTableColumn.getIsIncrement());
            this.genTableColumnDao.save(genTableColumn);
        }
        genTable.setUpdateBy(currentUser.getUsername());
        genTable.setUpdateTime(new Date());
        return this.genTableDao.save(genTable);
    }

    public GenTable findById(Long id) {
        return this.genTableDao.findById(id);
    }

    public void searchForPage(GenTablePageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.genTableDao.searchForPage(dto, page);
    }

    public void importBatch(List<GenTable> list) {
        List dbList = this.genTableDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GenTable genTable : list) {
                genTable.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    genTable.setUpdateTime(DateUtil.dateAdd((int)6, (Date)genTable.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.genTableDao.saveBatch(list);
        }
    }

    public List<GenTable> findByBatchId(List<GenTable> list) {
        return this.genTableDao.findByBatchId(list);
    }

    public List<GenTable> selectDbTableListByNames(String[] tableNames) {
        return this.genTableDao.selectDbTableListByNames(tableNames);
    }

    public void updateSelective(GenTable genTable) {
        User currentUser = this.arsUtil.getCurrentUser();
        genTable.setUpdateTime(new Date());
        genTable.setUpdateBy(currentUser.getUsername());
        this.genTableDao.updateSelective(genTable);
    }

    @Transactional
    public void importGenTable(List<GenTable> tableList) {
        try {
            User currentUser = this.arsUtil.getCurrentUser();
            for (GenTable table : tableList) {
                String tableName = table.getTableName();
                GenUtils.initTable(table, currentUser.getUsername());
                int row = this.genTableDao.save(table);
                if (row <= 0) continue;
                List genTableColumns = this.genTableColumnDao.selectDbTableColumnsByName(tableName);
                for (GenTableColumn column : genTableColumns) {
                    GenUtils.initColumnField(column, table);
                    column.setTableId(table.getTableId() + "");
                    this.genTableColumnDao.save(column);
                }
            }
        }
        catch (Exception e) {
            throw new ArsException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void selectDbTableList(GenTable genTable, AjaxPageResponse<GenTable> page) {
        this.genTableDao.selectDbTableList(genTable, page);
    }

    public Map<String, String> previewCode(Long tableId) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        GenTable table = this.genTableDao.findDetail(tableId);
        this.setPkColumn(table);
        VelocityInitializer.initVelocity();
        VelocityContext context = VelocityUtils.prepareContext(table);
        this.setMenuInfo(context, table);
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates) {
            if (template.endsWith("sql.vm") && StringUtil.isEmpty((String)table.getParentMenuId())) continue;
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            dataMap.put(template, sw.toString());
        }
        return dataMap;
    }

    public byte[] downloadCode(String tableName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.generatorCode(tableName, zip);
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    public byte[] downloadCode(String[] tableNames) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames) {
            this.generatorCode(tableName, zip);
        }
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    private void generatorCode(String tableName, ZipOutputStream zip) {
        GenTable table = this.genTableDao.selectGenTableByName(tableName);
        this.setPkColumn(table);
        VelocityInitializer.initVelocity();
        VelocityContext context = VelocityUtils.prepareContext(table);
        this.setMenuInfo(context, table);
        List<String> templates = VelocityUtils.getTemplateList(table.getTplCategory());
        for (String template : templates) {
            if (template.endsWith("sql.vm") && StringUtil.isEmpty((String)table.getParentMenuId())) continue;
            StringWriter sw = new StringWriter();
            Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
            tpl.merge((Context)context, (Writer)sw);
            try {
                zip.putNextEntry(new ZipEntry(VelocityUtils.getFileName(template, table)));
                IOUtils.write((String)sw.toString(), (OutputStream)zip, (String)"UTF-8");
                IOUtils.closeQuietly((Writer)sw);
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e) {
                this.logger.error("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table.getTableName(), (Throwable)e);
            }
        }
    }

    private void setMenuInfo(VelocityContext context, GenTable table) {
        if (StringUtil.isNotEmpty((String)table.getParentMenuId())) {
            ModuleMenu moduleMenu = this.moduleMenuDao.findById(Long.valueOf(Long.parseLong(table.getParentMenuId())));
            context.put("parentMenuIds", (Object)moduleMenu.getParentIds());
            context.put("menuId", (Object)this.idWorker.nextId());
            context.put("viewMenuId", (Object)this.idWorker.nextId());
            context.put("addMenuId", (Object)this.idWorker.nextId());
            context.put("editMenuId", (Object)this.idWorker.nextId());
            context.put("removeMenuId", (Object)this.idWorker.nextId());
            context.put("exportMenuId", (Object)this.idWorker.nextId());
        }
    }

    public void setPkColumn(GenTable table) {
        for (GenTableColumn column : table.getColumns()) {
            if (!column.isPk()) continue;
            table.setPkColumn(column);
            break;
        }
        if (StringUtils.isNull((Object)table.getPkColumn())) {
            table.setPkColumn((GenTableColumn)table.getColumns().get(0));
        }
    }
}

