/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.service.certificate.GradeCertificateService;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeCertificate.class, getSeq=20000, getDataSyncType=SyncType.SYNC)
public class GradeCertificateServiceImpl
implements GradeCertificateService {
    @Autowired
    private GradeCertificateDao gradeCertificateDao;

    public List<GradeCertificate> query(GradeCertificateSearchDto dto, AjaxPageResponse<GradeCertificate> ajaxPageResponse) {
        return this.gradeCertificateDao.query(dto, ajaxPageResponse);
    }

    public GradeCertificate findById(Long id) {
        return this.gradeCertificateDao.findById(id);
    }

    public void update(GradeCertificate gradeCertificate) {
        GradeCertificate dbGradeCertificate = this.findById(gradeCertificate.getId());
        BeanUtils.copyPropertiesIgnore((Object)gradeCertificate, (Object)dbGradeCertificate, (Boolean)true);
        dbGradeCertificate.setUpdateTime(new Date());
        this.gradeCertificateDao.update(dbGradeCertificate);
    }

    public void saveOrUpdateForDS(GradeCertificate gradeCertificate) {
        GradeCertificate dbGradeCertificate = this.gradeCertificateDao.findById(gradeCertificate.getId());
        if (dbGradeCertificate != null) {
            if (gradeCertificate.getUpdateTime().getTime() > dbGradeCertificate.getUpdateTime().getTime()) {
                this.gradeCertificateDao.update(gradeCertificate);
            }
        } else {
            this.gradeCertificateDao.save(gradeCertificate);
        }
    }

    public List<Map<String, String>> insertBatchForImport(List<Map<String, String>> dataList) {
        int insertLength;
        Long importBatchId = new IdWorker().nextId();
        int i = 0;
        for (insertLength = dataList.size(); insertLength > 2000; insertLength -= 2000) {
            this.gradeCertificateDao.insertTempBatchGradeCertificateImport(dataList.subList(i, i + 2000), importBatchId);
            i += 2000;
        }
        if (insertLength > 0) {
            this.gradeCertificateDao.insertTempBatchGradeCertificateImport(dataList.subList(i, i + insertLength), importBatchId);
        }
        this.gradeCertificateDao.checkIdNumNoRepeat(importBatchId);
        this.gradeCertificateDao.checkInOtherCom(importBatchId);
        this.gradeCertificateDao.checkComparisonPerson(importBatchId);
        this.gradeCertificateDao.checkGradePerson(importBatchId);
        this.gradeCertificateDao.insertGradeCertificateInfo(importBatchId);
        List tempInputPerList = this.gradeCertificateDao.getTempImportGradeCertificateList(importBatchId);
        this.gradeCertificateDao.deleteTempBatchGradeCertificateImport(importBatchId);
        return tempInputPerList;
    }

    public List<GradeCertificate> findUnPushToSAAS() {
        return this.gradeCertificateDao.findUnPushToSAAS();
    }

    public void batchUpdatePushState(List<GradeCertificate> certificates) {
        this.gradeCertificateDao.batchUpdatePushState(certificates);
    }

    public void batchUpdatePersonGradeCertificate(List<GradeCertificate> certificates) {
        this.gradeCertificateDao.batchUpdatePersonGradeCertificate(certificates);
    }

    public List<GradeCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeCertificateDao.searchForDataSynchronization(dto);
    }

    public List<GradeCertificate> findByIdNums(String[] idNumArr) {
        return this.gradeCertificateDao.findByIdNums(idNumArr);
    }
}

