/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyDaoAop;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.certificate.ComCertificateSnapshotDao;
import com.bcxin.ars.dao.certificate.CompanyCertificateDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.CompanyCertificateService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Base64Img;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.QRCodeUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CompanyCertificate.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=CompanyCertificate.class, getImportType=ImportType.BATCH)
public class CompanyCertificateServiceImpl
implements CompanyCertificateService {
    private Logger logger = LoggerFactory.getLogger(CompanyCertificateServiceImpl.class);
    @Autowired
    private CompanyCertificateDao companyCertificateDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityCompanyDaoAop securityCompanyDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;
    @Autowired
    private SponsorlicenseDaoAop sponsorlicenseDaoAop;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private LegalchangeDao legalchangeDao;
    @Autowired
    private LegalchangeDaoAop legalchangeDaoAop;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private SyscodeDAO syscodeDAO;
    @Autowired
    private ProjectChangeDao projectChangeDao;
    @Autowired
    private CreatePDFService createPDFService;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ComCertificateSnapshotDao comCertificateSnapshotDao;
    @Autowired
    private SecurityCompanyService securityCompanyService;

    public CompanyCertificate findById(long id, String type) {
        CompanyCertificate companyCertificate = this.companyCertificateDao.findById(id);
        if (companyCertificate != null) {
            if (companyCertificate != null && companyCertificate.getCompanyid() != null) {
                companyCertificate.setCompany(this.securityCompanyDao.findById(companyCertificate.getCompanyid()));
            }
            try {
                String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
                String pathName = QRCodeUtil.generateQRCode((String)(cerUrl + "/mobile/companyCertificate/find/" + id + ".do?type=" + type), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                companyCertificate.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return companyCertificate;
    }

    public CompanyCertificate findByIdV2(long id, String type) {
        User currentUser = this.arsUtil.getCurrentUser();
        CompanyCertificate companyCertificate = this.companyCertificateDao.findById(id);
        Long qrCodeId = this.idWorker.nextId();
        if (companyCertificate != null) {
            if (companyCertificate != null && companyCertificate.getCompanyid() != null) {
                companyCertificate.setCompany(this.securityCompanyDao.findById(companyCertificate.getCompanyid()));
            }
            ComCertificateSnapshot comCertificateSnapshot = new ComCertificateSnapshot();
            comCertificateSnapshot.setQrCodeId(qrCodeId);
            BeanUtils.copyPropertiesIgnore((Object)companyCertificate, (Object)comCertificateSnapshot, (Boolean)true);
            comCertificateSnapshot.setCreateTime(new Date());
            comCertificateSnapshot.setUpdateTime(new Date());
            comCertificateSnapshot.setCreateBy(currentUser.getUsername());
            if (this.comCertificateSnapshotDao.save(comCertificateSnapshot) <= 0) {
                this.logger.error("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u4fdd\u5b58\u5feb\u7167\u51fa\u9519\uff01");
            }
            try {
                String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
                String pathName = QRCodeUtil.generateQRCode((String)(cerUrl + "/mobile/comCertificateSnapshot/findByQrCodeId/" + qrCodeId + ".do?type=" + type), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                companyCertificate.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return companyCertificate;
    }

    public CompanyCertificate findById(long id) {
        return this.findById(id, "1");
    }

    public void updateAndCreatePDF(CompanyCertificate companyCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        String[] projectname = new String[]{};
        String[] projectcontent = new String[]{};
        String[] projecttime = new String[]{};
        if (null != companyCertificate.getProjectChange()) {
            if (StringUtil.isNotEmpty((String)companyCertificate.getProjectChange().getProjectname())) {
                projectname = companyCertificate.getProjectChange().getProjectname().split(",");
            }
            if (StringUtil.isNotEmpty((String)companyCertificate.getProjectChange().getProjectcontent())) {
                projectcontent = companyCertificate.getProjectChange().getProjectcontent().split(",");
            }
            if (StringUtil.isNotEmpty((String)companyCertificate.getProjectChange().getProjecttime())) {
                projecttime = companyCertificate.getProjectChange().getProjecttime().split(",");
            }
        }
        int[] a = new int[]{projectname.length, projectcontent.length, projecttime.length};
        int counta = StringUtil.getMax((int[])a);
        this.projectChangeDao.deleteByCidAndType(companyCertificate.getId().toString(), "001");
        for (int i = 0; i < counta; ++i) {
            ProjectChange projectChange = new ProjectChange();
            projectChange.setActive(Boolean.valueOf(true));
            projectChange.setCreateTime(new Date());
            projectChange.setUpdateTime(new Date());
            projectChange.setUpdateBy(currentUser.getUsername());
            projectChange.setCertificateId(companyCertificate.getId());
            projectChange.setType("001");
            if (companyCertificate.getProjectChange() != null) {
                if (!StringUtil.isEmpty((String)companyCertificate.getProjectChange().getProjectname()) && projectname.length > i) {
                    projectChange.setProjectname(projectname[i]);
                }
                if (!StringUtil.isEmpty((String)companyCertificate.getProjectChange().getProjectcontent()) && projectcontent.length > i) {
                    projectChange.setProjectcontent(projectcontent[i]);
                }
                if (!StringUtil.isEmpty((String)companyCertificate.getProjectChange().getProjecttime()) && projecttime.length > i) {
                    projectChange.setProjecttime(projecttime[i]);
                }
            }
            this.projectChangeDao.save(projectChange);
        }
        CompanyCertificate dbCompanyCertificate = this.companyCertificateDao.findById(companyCertificate.getId().longValue());
        if (dbCompanyCertificate != null) {
            BeanUtils.copyPropertiesIgnore((Object)companyCertificate, (Object)dbCompanyCertificate, (Boolean)true);
            dbCompanyCertificate.setUpdateTime(new Date());
            dbCompanyCertificate.setUpdateflag(Boolean.valueOf(true));
            if (StringUtil.isEmpty((String)dbCompanyCertificate.getHasOld())) {
                dbCompanyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
                dbCompanyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
            }
            dbCompanyCertificate.setUpdateBy(currentUser.getUsername());
            dbCompanyCertificate.setPdfpath(null);
            dbCompanyCertificate.setPdfpathRevese(null);
            this.companyCertificateDao.update(dbCompanyCertificate);
        } else {
            new ArsException("\u67e5\u627e\u4e0d\u5230\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bc1\u4e66\u4fe1\u606f");
        }
        PdfFormDto pdfFormDto = new PdfFormDto();
        pdfFormDto.setBusinesstype("001");
        pdfFormDto.setBusinessid(companyCertificate.getId());
        try {
            this.createPDFService.createPDF(pdfFormDto);
        }
        catch (Exception e) {
            new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
        }
    }

    public void saveOrUpdateForLegalchange(CompanyCertificate companyCertificate) {
        Approval approval;
        SecurityCompany company;
        User currentUser = this.arsUtil.getCurrentUser();
        Legalchange legalchange = this.legalchangeDao.findById(companyCertificate.getLegalchangeId());
        Syscode syscode = this.syscodeDAO.selectByPrimaryKey("FWXKZH", currentUser.getCityAreaCode());
        if (null == syscode) {
            new ArsException("\u516c\u4fdd\u670d\u533a\u57df\u672a\u914d\u7f6e\uff01\uff01");
        }
        if (null != companyCertificate.getFwfw() && !companyCertificate.getFwfw().contains("20") || null == companyCertificate.getFwfw()) {
            companyCertificate.setOtherSecScopeType(null);
        }
        if (null == (company = this.securityCompanyDao.findById(companyCertificate.getCompanyid()))) {
            throw new ArsException("\u5185\u7f51\u4e0d\u5b58\u5728\u5916\u7f51\u5bf9\u5e94\u7684\u516c\u53f8!");
        }
        companyCertificate.setXkzh(syscode.getCodename() + company.getPublicSecurityLicenseNumber());
        companyCertificate.setActive(Boolean.valueOf(true));
        companyCertificate.setSlr(currentUser.getUsername());
        companyCertificate.setSlrsj(currentUser.getPhone());
        companyCertificate.setCreateTime(new Date());
        companyCertificate.setUpdateTime(new Date());
        companyCertificate.setUpdateBy(currentUser.getUsername());
        companyCertificate.setAreaCode(legalchange.getDistrict());
        companyCertificate.setOrgId(legalchange.getOrgid());
        companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
        companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
        companyCertificate.setApplytype(Constants.TYPE_CHANGER);
        companyCertificate.setUpdateflag(Boolean.valueOf(true));
        this.companyCertificateDao.save(companyCertificate);
        PdfFormDto pdfFormDto = new PdfFormDto();
        pdfFormDto.setBusinesstype("001");
        pdfFormDto.setBusinessid(companyCertificate.getId());
        try {
            this.createPDFService.createPDF(pdfFormDto);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
        }
        legalchange.setCardState(Constants.CARDSTATE_YES);
        this.legalchangeDaoAop.update(legalchange);
        this.projectChangeDao.deleteByCidAndType(companyCertificate.getId().toString(), "001");
        if (StringUtil.isNotEmpty((String)legalchange.getSecurityScopes())) {
            this.insertProject(Constants.CHANGE_FWFW, legalchange.getSecurityScopes(), companyCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getCompanyname())) {
            this.insertProject(Constants.CHANGE_NAME, legalchange.getCompanyname(), companyCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getAddress())) {
            this.insertProject(Constants.CHANGE_ADDRESS, legalchange.getAddress(), companyCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getLegalname())) {
            this.insertProject(Constants.CHANGE_LEGALNAME, legalchange.getLegalname(), companyCertificate.getId());
        }
        if (legalchange.getBgregisteredMoney() != null) {
            this.insertProject(Constants.CHANGE_ZJ, legalchange.getBgregisteredMoney().toString(), companyCertificate.getId());
        }
        if ((approval = this.approvalDAO.findBybusinessidAndType(legalchange.getId(), "007")) != null) {
            approval.setNextPerson(null);
            this.approvalDAO.update(approval);
        }
    }

    public void insertProject(String projectname, String projectcontent, Long certificateId) {
        User currentUser = this.arsUtil.getCurrentUser();
        ProjectChange projectChange = new ProjectChange();
        projectChange.setActive(Boolean.valueOf(true));
        projectChange.setCreateTime(new Date());
        projectChange.setUpdateTime(new Date());
        projectChange.setUpdateBy(currentUser.getUsername());
        projectChange.setCertificateId(certificateId);
        projectChange.setType("001");
        projectChange.setProjectname(projectname);
        projectChange.setProjectcontent(projectcontent);
        projectChange.setProjecttime(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd"));
        this.projectChangeDao.save(projectChange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveOrUpdate(CompanyCertificate companyCertificate) {
        Syscode syscode;
        User currentUser = this.arsUtil.getCurrentUser();
        Sponsorlicense sponsorlicense = null;
        if (companyCertificate.getSponsorlicenseid() != null) {
            sponsorlicense = this.sponsorlicenseDao.findById(companyCertificate.getSponsorlicenseid());
            companyCertificate.setOrgId(sponsorlicense.getOrgid());
            companyCertificate.setAreaCode(sponsorlicense.getDistrict());
        }
        if (null == (syscode = this.syscodeDAO.selectByPrimaryKey("FWXKZH", currentUser.getCityAreaCode()))) {
            throw new ArsException("\u516c\u4fdd\u670d\u533a\u57df\u672a\u914d\u7f6e\uff01\uff01");
        }
        if (null != companyCertificate.getFwfw() && !companyCertificate.getFwfw().contains("20") || null == companyCertificate.getFwfw()) {
            companyCertificate.setOtherSecScopeType(null);
        }
        if (StringUtil.isEmpty((String)companyCertificate.getXkzh())) {
            if (companyCertificate.getCompanyid() != null) {
                SecurityCompany company = this.securityCompanyDao.findById(companyCertificate.getCompanyid());
                if (null == company) throw new ArsException("\u5185\u7f51\u4e0d\u5b58\u5728\u5916\u7f51\u5bf9\u5e94\u7684\u516c\u53f8!");
                companyCertificate.setXkzh(syscode.getCodename() + company.getPublicSecurityLicenseNumber());
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                Date date = new Date();
                String year = "";
                if (syscode != null && syscode.getCodename() != null) {
                    year = syscode.getCodename() + simpleDateFormat.format(date);
                }
                CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
                resultDto.setXkzh(year);
                String maxXkzh_year = this.companyCertificateDao.searchMaxXkzhCount(resultDto);
                maxXkzh_year = StringUtils.isEmpty((Object)maxXkzh_year) ? year + "0001" : maxXkzh_year.substring(0, maxXkzh_year.length() - 8) + String.valueOf(Long.valueOf(maxXkzh_year.substring(maxXkzh_year.length() - 8)) + 1L);
                companyCertificate.setXkzh(maxXkzh_year);
                String username = this.configDao.findByKey("COMPANY_ACCOUNT_ROLE").getValue() + companyCertificate.getXkzh().replace(syscode.getCodename(), "");
                User existUser = this.userDao.findByUsername(username, String.valueOf(2));
                if (existUser != null) {
                    throw new ArsException("\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u53f7\u5df2\u5b58\u5728!");
                }
            }
        }
        if (companyCertificate.getId() == null) {
            companyCertificate.setActive(Boolean.valueOf(true));
            companyCertificate.setSlr(currentUser.getUsername());
            companyCertificate.setSlrsj(currentUser.getPhone());
            companyCertificate.setCreateTime(new Date());
            companyCertificate.setUpdateTime(new Date());
            companyCertificate.setUpdateBy(currentUser.getUsername());
            companyCertificate.setUpdateflag(Boolean.valueOf(true));
            companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
            companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
            if (StringUtil.isEmpty((String)companyCertificate.getAreaCode())) {
                companyCertificate.setOrgId(currentUser.getOrgid());
                companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
            }
            companyCertificate.setApplytype(Constants.TYPE_APPLY);
            this.companyCertificateDao.save(companyCertificate);
            PdfFormDto pdfFormDto = new PdfFormDto();
            pdfFormDto.setBusinesstype("001");
            pdfFormDto.setBusinessid(companyCertificate.getId());
            try {
                this.createPDFService.createPDF(pdfFormDto);
            }
            catch (Exception e) {
                throw new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
            }
        } else {
            CompanyCertificate dbCompanyCertificate = this.companyCertificateDao.findById(companyCertificate.getId().longValue());
            if (dbCompanyCertificate != null) {
                companyCertificate.setUpdateBy(currentUser.getUsername());
                companyCertificate.setUpdateTime(new Date());
                companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
                companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
                companyCertificate.setUpdateflag(Boolean.valueOf(true));
                companyCertificate.setApplytype(Constants.TYPE_APPLY);
                if (StringUtil.isEmpty((String)dbCompanyCertificate.getAreaCode()) && StringUtil.isEmpty((String)companyCertificate.getAreaCode())) {
                    companyCertificate.setOrgId(currentUser.getOrgid());
                    companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
                }
                this.companyCertificateDao.update(companyCertificate);
            } else {
                new ArsException("\u67e5\u627e\u4e0d\u5230\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bc1\u4e66\u4fe1\u606f");
            }
        }
        if (sponsorlicense == null) return;
        sponsorlicense.setCardState("2");
        sponsorlicense.setUpdateTime(new Date());
        sponsorlicense.setUpdateBy(currentUser.getUsername());
        this.sponsorlicenseDaoAop.update(sponsorlicense);
        Config configVersion = this.configDao.findByKey("APPROVAL_VERSION_SWITCH");
        if (configVersion == null || !"1".equals(configVersion.getValue())) return;
        User newUser = new User();
        newUser.setInit(Boolean.valueOf(false));
        newUser.setRealname(sponsorlicense.getCompanyname());
        newUser.setPhone(sponsorlicense.getPhone());
        newUser.setPlatform(Integer.valueOf(2));
        SecurityCompany newCompany = new SecurityCompany();
        newCompany.setName(sponsorlicense.getCompanyname());
        newCompany.setSponsorlicenseType(sponsorlicense.getSponsorlicenseType());
        newCompany.setPublicSecurityLicenseNumber(companyCertificate.getXkzh().replace(syscode.getCodename(), ""));
        newCompany.setLegalPerson(sponsorlicense.getRepresentative());
        newCompany.setLegalPersonNo(sponsorlicense.getLegalPersonNo());
        newCompany.setLocation(sponsorlicense.getAddress());
        newCompany.setOtherSecScopeType(sponsorlicense.getOtherSecScopeType());
        Approval approval = this.approvalDAO.findBybusinessidAndType(companyCertificate.getSponsorlicenseid(), "001");
        if (null != approval) {
            newCompany.setAreaCode(approval.getAreaCode());
        }
        newCompany.setRegisteredMoney(new BigDecimal(sponsorlicense.getRegcapital().toString()));
        newCompany.setEconomicType(sponsorlicense.getEnterprisetype());
        newCompany.setTel(sponsorlicense.getTel());
        newCompany.setSecurityScopeType(sponsorlicense.getManagement());
        newCompany.setUser(newUser);
        newCompany.setOrgId(sponsorlicense.getOrgid().toString());
        Police police = this.policeDao.findById(sponsorlicense.getOrgid());
        newCompany.setOrgName(this.policeDao.findOrgNameByOrgIds(police.getPath().split("/")));
        newCompany.setInstitutionType("0102");
        newCompany.setUpdateflag(Boolean.valueOf(true));
        newCompany.setGiveLicenseDate(companyCertificate.getFzrq());
        newCompany.setGiveLicenseName(companyCertificate.getFzjgmc());
        this.securityCompanyService.updateCompany(newCompany);
    }

    public CompanyCertificateSearchDto search(CompanyCertificateSearchDto dto) {
        CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
        List list = this.companyCertificateDao.search(dto);
        resultDto.setTotalCount(this.companyCertificateDao.searchCount(dto));
        resultDto.setData(list);
        return resultDto;
    }

    public void delete(CompanyCertificate companyCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        companyCertificate.setUpdateBy(currentUser.getUsername());
        companyCertificate.setUpdateTime(new Date());
        this.companyCertificateDao.delete(companyCertificate);
    }

    public CompanyCertificate findBySponsorLicenseId(Long sponsorlicenseid) {
        return this.companyCertificateDao.findBySponsorLicenseId(sponsorlicenseid);
    }

    public void updateCompanyCertificate(CompanyCertificate companyCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        CompanyCertificate dbCompanyCertificate = this.companyCertificateDao.findByCompanyId(companyCertificate.getCompanyid());
        companyCertificate.setAreaCode(dbCompanyCertificate.getAreaCode());
        companyCertificate.setOrgId(dbCompanyCertificate.getOrgId());
        if (StringUtil.isEmpty((String)companyCertificate.getAreaCode())) {
            SecurityCompany company = this.securityCompanyDao.findById(companyCertificate.getCompanyid());
            if (company.getOrgId() != null) {
                companyCertificate.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
                companyCertificate.setAreaCode(company.getAreaCode());
            } else {
                companyCertificate.setOrgId(currentUser.getOrgid());
                companyCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
            }
        }
        companyCertificate.setXkzh(dbCompanyCertificate.getXkzh());
        companyCertificate.setPzwh(dbCompanyCertificate.getPzwh());
        companyCertificate.setFzrq(dbCompanyCertificate.getFzrq());
        companyCertificate.setFzjgmc(dbCompanyCertificate.getFzjgmc());
        companyCertificate.setFrdblx(dbCompanyCertificate.getFrdblx());
        companyCertificate.setZczblx(dbCompanyCertificate.getZczblx());
        companyCertificate.setSponsorlicenseid(dbCompanyCertificate.getSponsorlicenseid());
        companyCertificate.setZzrq(dbCompanyCertificate.getZzrq());
        companyCertificate.setActive(Boolean.valueOf(true));
        companyCertificate.setSlr(currentUser.getUsername());
        companyCertificate.setSlrsj(currentUser.getPhone());
        companyCertificate.setCreateTime(new Date());
        companyCertificate.setUpdateTime(new Date());
        companyCertificate.setUpdateBy(currentUser.getUsername());
        companyCertificate.setUpdateflag(Boolean.valueOf(true));
        companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
        companyCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
        this.companyCertificateDao.save(companyCertificate);
    }

    public CompanyCertificate findByCompanyname(String companyname) {
        return this.companyCertificateDao.findByCompanyname(companyname);
    }

    public CompanyCertificate findByCompanyId(Long companyId) {
        return this.companyCertificateDao.findByCompanyId(companyId);
    }

    public List<CompanyCertificate> findByXkzh(String xkzh) {
        return this.companyCertificateDao.findByXkzh(xkzh);
    }

    public List<CompanyCertificate> findDataByXkzhHistory(String xkzh) {
        return this.companyCertificateDao.findDataByXkzhHistory(xkzh);
    }

    public void updatePrintedByid(Long id) {
        CompanyCertificate companyCertificate = this.companyCertificateDao.findById(id.longValue());
        if (companyCertificate.getPrintcount() == null || companyCertificate.getPrintcount().equals("")) {
            companyCertificate.setPrintcount("1");
        } else {
            int printcount = Integer.parseInt(companyCertificate.getPrintcount()) + 1;
            companyCertificate.setPrintcount(printcount + "");
        }
        companyCertificate.setPrintTime(new Date());
        companyCertificate.setHasprint(true);
        this.companyCertificateDao.update(companyCertificate);
    }

    public CompanyCertificateSearchDto searchLegalangeChange(CompanyCertificateSearchDto dto) {
        CompanyCertificateSearchDto resultDto = new CompanyCertificateSearchDto();
        List list = this.companyCertificateDao.searchLegalangeChange(dto);
        resultDto.setTotalCount(this.companyCertificateDao.searchLegalangeChangeCount(dto));
        resultDto.setData(list);
        return resultDto;
    }

    public void createPdfBatch() {
        List list = this.companyCertificateDao.searchUnPdf();
        if (null != list && list.size() > 0) {
            PdfFormDto pdfFormDto = new PdfFormDto();
            pdfFormDto.setBusinesstype("001");
            new Thread(() -> {
                try {
                    for (CompanyCertificate companyCertificate : list) {
                        pdfFormDto.setBusinessid(companyCertificate.getId());
                        try {
                            this.createPDFService.createPDF(pdfFormDto);
                        }
                        catch (Exception e) {
                            new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } else {
            new ArsException("\u6ca1\u6709\u9700\u8981\u751f\u6210PDF\u7684\u8bc1\u4e66\u6570\u636e");
        }
    }

    public void searchForPage(CompanyCertificateSearchDto dto, AjaxPageResponse<CompanyCertificate> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.companyCertificateDao.searchForPage(dto, page);
    }

    public void saveForRepair(CompanyCertificate companyCertificate) {
        SecurityCompany company;
        User currentUser = this.arsUtil.getCurrentUser();
        String zkzh = this.configUtils.getValueByKey("current_native_short");
        zkzh = zkzh + "\u516c\u4fdd\u670d";
        companyCertificate.setXkzh(companyCertificate.getXkzh().replace(zkzh, ""));
        if ("2".equals(companyCertificate.getIsInSystem())) {
            String gsmcDefine = companyCertificate.getGsmcDefine();
            companyCertificate.setGsmc(gsmcDefine);
            companyCertificate.setCompanyid(null);
        } else if (companyCertificate.getCompanyid() != null && (company = this.securityCompanyDao.findById(companyCertificate.getCompanyid())) != null && StringUtil.isNotEmpty((String)company.getOrgId())) {
            companyCertificate.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
            companyCertificate.setAreaCode(company.getAreaCode());
        }
        if (companyCertificate.getId() == null) {
            companyCertificate.setActive(Boolean.valueOf(true));
            companyCertificate.setSlr(currentUser.getUsername());
            companyCertificate.setSlrsj(currentUser.getPhone());
            companyCertificate.setCreateTime(new Date());
            companyCertificate.setUpdateTime(new Date());
            companyCertificate.setUpdateBy(currentUser.getUsername());
            companyCertificate.setUpdateflag(Boolean.valueOf(true));
            companyCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
            companyCertificate.setPrinttype(Constants.TYPE_PRINT_HZ);
            companyCertificate.setApplytype(Constants.TYPE_CHANGER);
            if (StringUtil.isEmpty((String)companyCertificate.getAreaCode())) {
                companyCertificate.setAreaCode(currentUser.getPolice().getAreacode());
                companyCertificate.setOrgId(currentUser.getOrgid());
            }
            this.companyCertificateDao.save(companyCertificate);
        } else {
            CompanyCertificate dbCompanyCertificate = this.companyCertificateDao.findById(companyCertificate.getId().longValue());
            BeanUtils.copyPropertiesIgnore((Object)companyCertificate, (Object)dbCompanyCertificate, (Boolean)true);
            dbCompanyCertificate.setUpdateflag(Boolean.valueOf(true));
            dbCompanyCertificate.setUpdateTime(new Date());
            if (dbCompanyCertificate.getIsInSystem().equals("2")) {
                dbCompanyCertificate.setCompanyid(null);
            }
            if (StringUtil.isEmpty((String)dbCompanyCertificate.getAreaCode())) {
                dbCompanyCertificate.setAreaCode(currentUser.getPolice().getAreacode());
                dbCompanyCertificate.setOrgId(currentUser.getOrgid());
            }
            this.companyCertificateDao.update(dbCompanyCertificate);
        }
        PdfFormDto pdfFormDto = new PdfFormDto();
        pdfFormDto.setBusinesstype("001");
        pdfFormDto.setBusinessid(companyCertificate.getId());
        try {
            this.createPDFService.createPDF(pdfFormDto);
        }
        catch (Exception e) {
            throw new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
        }
    }

    public List<CompanyCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.companyCertificateDao.searchForDataSynchronization(searchDto);
    }

    public List<CompanyCertificate> findDSOutList(String startDate) {
        return this.companyCertificateDao.findDSOutList(startDate);
    }

    public void importBatch(List<CompanyCertificate> list) {
        List dbList = this.companyCertificateDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CompanyCertificate companyCertificate : list) {
                companyCertificate.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (!this.configUtils.isIntranet()) {
                        companyCertificate.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyCertificate.getUpdateTime(), (int)1));
                    }
                    SecurityCompany company = this.securityCompanyDao.findById(companyCertificate.getCompanyid());
                    company.setGiveLicenseDate(companyCertificate.getFzrq());
                    company.setGiveLicenseName(companyCertificate.getFzjgmc());
                    this.securityCompanyDaoAop.update(company);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.companyCertificateDao.saveBatch(list);
        }
    }
}

