package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.google.common.collect.Maps;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * 证件类型
 * @author zhangyutong
 */
public class ManagerCardTypeMinDataFormatStrategy implements MinDataFormatStrategy{
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        Map<String,String> managerCardTypes = Maps.newHashMapWithExpectedSize(10);
        // 身份证
        managerCardTypes.put("1","01");
        // 护照
        managerCardTypes.put("2","03");
        // 港澳通行证
        managerCardTypes.put("3","04");
        // 台湾居民来往大陆通行证
        managerCardTypes.put("4","05");
        return managerCardTypes.get(String.valueOf(data));
    }
}
