package com.bcxin.ars.model.sb;


import com.bcxin.ars.model.BusinessCommon;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 等级证补贴批次
 *
 * @author linqinglin
 * @Date 2020-05-18 19:39:33
 */
@Data
public class GradeSubsidyBatch extends BusinessCommon {

    private static final long serialVersionUID = 1L;
    /**
    * 申请时间
    * 
    */
    private Date applyTime;
    /**
    * 机构名称
    * 
    */
    private String orgName;
    /**
    * 批次名称
    * 
    */
    private String batchName;
    /**
    * 培训机构联系人
    * 
    */
    private String contact;
    /**
    * 联系方式
    * 
    */
    private String phone;
    /**
    * 培训机构地址
    * 
    */
    private String address;
    /**
    * 备注
    * 
    */
    private String remark;
    /**
    * 批次人数
    * 
    */
    private String perNum;
    /**
    * 补贴总额
    * 
    */
    private String subsidyMoney;

    /**
     * 补贴证书类型 01等级证 or 02资格证
     */
    private String subsidyCerType;

    /**
     * 平台补贴服务费
     */
    private String platSerFee;

    /**
     * 交易流水号
     */
    private String orderNo;
    /**
     * 补贴发放状态
     */
    private String grantState;

    /**
     * 线下审批状态 002初审通过 003审批通过 004审批不通过 005线下审批中
     * 线下审批状态 002待审批 003初审通过 0031审批通过 004审批不通过 005初审中 0051线下审批中
     */
    private String offApprovalState;

    /**
     * 打回原因
     */
    private String reason;

    /**
     * 承诺书路径
     */
    private String commitPath;


    private Long[] rosterIds;

    public BigDecimal getSubsidyMoney_value(){
        if(StringUtils.isEmpty(this.subsidyMoney)){
            return new BigDecimal(0);
        }
        return new BigDecimal(this.subsidyMoney);
    }

    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}