package com.bcxin.ars.model.sb;

import java.util.Date;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

/**
 * 枪支管理
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年5月18日 下午4:56:04
 * @注意事项 </b>
 * <b>
 */
@Data
public class Firearms extends BaseModel {

    /**  */
	private static final long serialVersionUID = -7050425166564539930L;

    @ModelAnnotation(getName="用户ID",column = "userid")
	private Long userid;

	/**
	 * 枪号
	 */
    @ModelAnnotation(getName="枪号",column = "firearmsnum")
    private String firearmsnum;

	/**
	 * 枪支型号
	 */
    @ModelAnnotation(getName="枪支型号",column = "firearmsxh")
    private String firearmsxh;

	/**
	 * 枪支制作企业
	 */
    @ModelAnnotation(getName="枪支制作企业",column = "firearmscompany")
    private String firearmscompany;

	/**
	 * 枪支购买日期
	 */
    @ModelAnnotation(getName="枪支购买日期",column = "firearmsbuydate")
    private Date firearmsbuydate;

	/**
	 * 枪支专管人
	 */
    @ModelAnnotation(getName="枪支专管人",column = "firearmsperson")
    private String firearmsperson;

	/**
	 * 建立枪弹痕迹档案情况
	 */
    @ModelAnnotation(getName="建立枪弹痕迹档案情况",column = "firearmscontext")
    private String firearmscontext;

	/**
	 * 备注
	 */
    @ModelAnnotation(getName="备注",column = "remarks")
    private String remarks;

    /**
     * 枪支状态(1已领用2在库3已遗失4已注销)
     */
    @ModelAnnotation(getName="枪支状态",column = "firearmsstate")
    private String firearmsstate;

    /**
     *使用者姓名
     * @return
     */
    @ModelAnnotation(getName="使用者姓名",column = "usename")
    private String usename;

    /**
     *使用时间
     * @return
     */
    @ModelAnnotation(getName="使用时间",column = "usedate")
    private String usedate;

    /**
     *使用原因
     * @return
     */
    @ModelAnnotation(getName="使用原因",column = "useexplain")
    private String useexplain;

    /**
     *发证单位
     * @return
     */
    @ModelAnnotation(getName="发证单位",column = "firearmcertification")
    private String firearmcertification;


    private String companyName;

    public String getUsename() {
        return usename;
    }

    public void setUsename(String usename) {
        this.usename = usename;
    }

    public String getUsedate() {
        return usedate;
    }

    public void setUsedate(String usedate) {
        this.usedate = usedate;
    }

    public String getUseexplain() {
        return useexplain;
    }

    public void setUseexplain(String useexplain) {
        this.useexplain = useexplain;
    }

    public String getFirearmcertification() {
        return firearmcertification;
    }

    public void setFirearmcertification(String firearmcertification) {
        this.firearmcertification = firearmcertification;
    }

    public Long getUserid() {
    	return userid;
    }
    
    public void setUserid(Long userid) {
    	this.userid = userid;
    }
    
    public String getFirearmsstate() {
        return firearmsstate;
    }

    public void setFirearmsstate(String firearmsstate) {
        this.firearmsstate = firearmsstate;
    }

    public String getFirearmsnum() {
        return firearmsnum;
    }

    public void setFirearmsnum(String firearmsnum) {
        this.firearmsnum = firearmsnum == null ? null : firearmsnum.trim();
    }

    public String getFirearmsxh() {
        return firearmsxh;
    }

    public void setFirearmsxh(String firearmsxh) {
        this.firearmsxh = firearmsxh == null ? null : firearmsxh.trim();
    }

    public String getFirearmscompany() {
        return firearmscompany;
    }

    public void setFirearmscompany(String firearmscompany) {
        this.firearmscompany = firearmscompany == null ? null : firearmscompany.trim();
    }

    public Date getFirearmsbuydate() {
        return firearmsbuydate;
    }

    public void setFirearmsbuydate(Date firearmsbuydate) {
        this.firearmsbuydate = firearmsbuydate;
    }

    public String getFirearmsperson() {
        return firearmsperson;
    }

    public void setFirearmsperson(String firearmsperson) {
        this.firearmsperson = firearmsperson == null ? null : firearmsperson.trim();
    }

    public String getFirearmscontext() {
        return firearmscontext;
    }

    public void setFirearmscontext(String firearmscontext) {
        this.firearmscontext = firearmscontext == null ? null : firearmscontext.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }
}