package com.bcxin.ars.model.gx;

import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;


/**
 * 广西一体化申报请求数据对象
 *
 * @table gx_internet_plus_business
 * @author lin
 * @date 2022-04-13
 */
@Data
public class InternetPlusBusiness extends BaseModel {

    private static final long serialVersionUID=1L;


    /**
     * 受理编号
     */
    private String sdono;
    /**
     * 业务类型编号
     */
    private String sbusno;
    /**
     * 业务类型名称
     */
    private String sbusname;
    /**
     * 业务内容
     */
    private String sdodata;
    /**
     * 受理单位
     */
    private String sdounit;
    /**
     * 受理单位代码
     */
    private String sdounitno;
    /**
     * 用户账号
     */
    private String suserid;
    /**
     * 申请人身份号码
     */
    private String sappid;
    /**
     * 申请人姓名
     */
    private String sappname;
    /**
     * 申请人电话号码
     */
    private String sapptel;
    /**
     * 认证等级
     */
    private String person_grade;
    /**
     * 寄送方式
     */
    private String ssendtype;
    /**
     * 回寄方式
     */
    private String sbacktype;
    /**
     * 回寄地址
     */
    private String sbackaddr;
    /**
     * 业务状态
     */
    private String state;
    /**
     * 业务申报材料集合
     */
    private String sCldatas;
    /**
     * 申报数据的属性参数
     */
    private String sData;
    /**
     * 最后一次操作时间（时间戳）
     */
    private String sdotime;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long businessId;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
