package com.bcxin.ars.model.gx;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;

import java.io.Serializable;

/**
 * 广西公安互联网+平台推送流水号到业务办理系统返回对接
 * @author subh
 * @since jdk1.8
 */
@JsonRootName("RESULT")
public class IntegratedResult implements Serializable {

    /***
     * 响应代码----成功
     */
    public static final String SUCCESS = "200";
    /***
     * 响应代码----成功消息
     */
    public static final String SUCCESS_MES = "处理成功";
    /***
     * 响应代码----失败
     */
    public static final String ERROR = "300";
    /**
     * 响应代码
     * JsonProperty 返回xml为大写
     */
    @JsonProperty("STATUS")
    private String status;


    /***
     * 接口返回文字描述信息
     * JsonProperty 返回xml为大写
     */
    @JsonProperty("DESC")
    private String desc;


    /**
     * 接口调用响应时间
     * JsonProperty 返回xml为大写
     */
    @JsonProperty("TIME")
    private String time;

    /***
     * 接口返回数据体
     * JsonProperty 返回xml为大写
     */
    @JsonProperty("DATA")
    private Object data;



    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}
