package com.bcxin.ars.model.gen;


import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * 代码生成业务表
 *
 * @author linqinglin
 * @Date 2020-08-09 08:11:23
 */
@Data
public class GenTable extends BaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 编号
     * 
     */
    private Long tableId;
    /**
     * 表名称
     * 
     */
    private String tableName;
    /**
     * 表描述
     * 
     */
    private String tableComment;
    /**
     * 关联子表的表名
     * 
     */
    private String subTableName;
    /**
     * 子表关联的外键名
     * 
     */
    private String subTableFkName;
    /**
     * 实体类名称
     * 
     */
    private String className;
    /**
     * 使用的模板（crud单表操作 tree树表操作 sub主子表操作）
     * 
     */
    private String tplCategory;
    /**
     * 生成包路径
     * 
     */
    private String packageName;
    /**
     * 生成模块名
     * 
     */
    private String moduleName;
    /**
     * 生成业务名
     * 
     */
    private String businessName;
    /**
     * 生成功能名
     * 
     */
    private String functionName;
    /**
     * 生成功能作者
     * 
     */
    private String functionAuthor;
    /**
     * 生成代码方式（0zip压缩包 1自定义路径）
     * 
     */
    private String genType;
    /**
     * 生成路径（不填默认项目路径）
     * 
     */
    private String genPath;
    /**
     * 创建者
     * 
     */
    private String createBy;
    /**
     * 备注
     * 
     */
    private String remark;

    /** 表列信息 */
    @Valid
    private List<GenTableColumn> columns;

    /** 上级菜单ID字段 */
    private String parentMenuId;

    /** 上级菜单名称字段 */
    private String parentMenuName;

    /** 主键信息 */
    private GenTableColumn pkColumn;


    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}