package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;


/**
 * 保安处罚信息
 * @author Ethan
 */
public class SbPunish extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})

	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	/**
	 * 姓名
	 */
	@ModelAnnotation(getName="姓名",column = "user_id")
	private String name;

	/**
	 * 身份证号
	 */
	@ModelAnnotation(getName="身份证号",column = "idnumber")
	private String idNumber;

	/**
	 * 员工编号
	 */
	@ModelAnnotation(getName="员工编号",column = "employeeid")
	private String employeeid;

	/**
	 * 部门名称
	 */
	@ModelAnnotation(getName="部门名称",column = "departname")
	private String departname;

	/**
	 * 处罚日期
	 */
	@ModelAnnotation(getName="处罚日期",column = "punishdate")
	private String punishDate;

	/**
	 * 处罚内容
	 */
	@ModelAnnotation(getName="处罚内容",column = "punishcontext")
	private String punishContext;

	/**
	 * 处罚原因
	 */
	@ModelAnnotation(getName="处罚原因",column = "punishreason")
	private String punishReason;

	/**
	 * 备注
	 */
	@ModelAnnotation(getName="备注",column = "remarks")
	private String remarks;

	/**
	 * 处罚单位
	 */
	@ModelAnnotation(getName="公司ID",column = "punishcompany")
	private String punishCompany;

	/**
	 * 是否公安机关作出
	 * @return
	 */
	@ModelAnnotation(getName="公司ID",column = "isbypolice")
	private String isByPolice;

	/**
	 * 与saas对接id
	 */
	private Long penaltyId;

	public Long getPenaltyId() {
		return penaltyId;
	}

	public void setPenaltyId(Long penaltyId) {
		this.penaltyId = penaltyId;
	}

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}
	
	public String getIsByPolice() {
		return isByPolice;
	}

	public void setIsByPolice(String isByPolice) {
		this.isByPolice = isByPolice;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}

	public String getEmployeeid() {
		return employeeid;
	}

	public void setEmployeeid(String employeeid) {
		this.employeeid = employeeid;
	}

	public String getDepartname() {
		return departname;
	}

	public void setDepartname(String departname) {
		this.departname = departname;
	}

	public String getPunishDate() {
		return punishDate;
	}

	public void setPunishDate(String punishDate) {
		this.punishDate = punishDate;
	}

	public String getPunishContext() {
		return punishContext;
	}

	public void setPunishContext(String punishContext) {
		this.punishContext = punishContext;
	}

	public String getPunishReason() {
		return punishReason;
	}

	public void setPunishReason(String punishReason) {
		this.punishReason = punishReason;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getPunishCompany() {
		return punishCompany;
	}

	public void setPunishCompany(String punishCompany) {
		this.punishCompany = punishCompany;
	}

	@Override
	public String toString() {
		return "Sbpunish{" +
				"user=" + user +
				", userid=" + userid +
				", name='" + name + '\'' +
				", idNumber='" + idNumber + '\'' +
				", employeeid='" + employeeid + '\'' +
				", departname='" + departname + '\'' +
				", punishDate='" + punishDate + '\'' +
				", punishContext='" + punishContext + '\'' +
				", punishReason='" + punishReason + '\'' +
				", remarks='" + remarks + '\'' +
				", punishCompany='" + punishCompany + '\'' +
				'}';
	}
}
