package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;

/**
 * 
 * <b>4.10	订单与保安人员关系信息表 </b>
 * 
 * @author LinQingLin
 * @date 2017年4月6日 下午3:00:00
 * @注意事项 </b>
 * <b>
 */
public class OrderPerson extends BaseModel{

    /**  */
	private static final long serialVersionUID = 486397493094175022L;

	/**
    * 订单ID
    */
    @ModelAnnotation(getName="订单ID",column = "orderid")
    private Long orderid;

    /**
    * 已学习时长（需要学习的时长）
    */
    @ModelAnnotation(getName="已学习时长",column = "studylong")
    private Integer studylong;

    /**
    * 报名时间
    */
    @ModelAnnotation(getName="报名时间",column = "signtime")
    private Date signtime;

    /**
    * 结束学习时间
    */
    @ModelAnnotation(getName="结束学习时间",column = "endtime")
    private Date endtime;

    /**
    * 姓名
    */
    @ModelAnnotation(getName="姓名",column = "name")
    private String name;

    /**
    * 手机
    */
    @ModelAnnotation(getName="手机",column = "phone")
    private String phone;

    /**
    * 公司名称
    */
    @ModelAnnotation(getName="公司名称",column = "companyName")
    private String companyname;

    /**
    * 保安级别 1初级保安员2中级保安员3高级保安员4保安管理员5高级保安师
    */
    @ModelAnnotation(getName="保安级别",column = "personlevel")
    private String personlevel;

    /**
    * 培训机构ID
    */
    @ModelAnnotation(getName="培训机构ID",column = "trainorgid")
    private Long trainorgid;

    /**
    * 公司ID
    */
    @ModelAnnotation(getName="公司ID",column = "companyid")
    private Long companyid;

    /**
    * 学习状态
    */
    @ModelAnnotation(getName="学习状态",column = "studystate")
    private String studystate;

    /**
    * 培训类型 1初级保安课程2继续教育
    */
    @ModelAnnotation(getName="培训类型",column = "traintype")
    private String traintype;

    /**
    * 视频个数
    */
    @ModelAnnotation(getName="视频个数",column = "videonum")
    private Integer videonum;

    /**
    * 学习进度(单位分钟)
    */
    @ModelAnnotation(getName="学习进度",column = "studyprogress")
    private Integer studyprogress;
    
    /**
     * 保安ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(getName="保安ID",column = "personid")
    private Long personid;

    @ModelAnnotation(getName="保安身份证号",column = "identitynumber")
    private String identitynumber;

    @ModelAnnotation(getName="组ID",column = "groupid")
    private String groupid;

    public String getIdentitynumber() {
        return identitynumber;
    }

    public void setIdentitynumber(String identitynumber) {
        this.identitynumber = identitynumber;
    }

    public String getGroupid() {
        return groupid;
    }

    public void setGroupid(String groupid) {
        this.groupid = groupid;
    }

    public Long getPersonid() {
		return personid;
	}

	public void setPersonid(Long personid) {
		this.personid = personid;
	}

	public Long getOrderid() {
        return orderid;
    }

    public void setOrderid(Long orderid) {
        this.orderid = orderid;
    }

    public Integer getStudylong() {
        return studylong;
    }

    public void setStudylong(Integer studylong) {
        this.studylong = studylong;
    }

    public Date getSigntime() {
        return signtime;
    }

    public void setSigntime(Date signtime) {
        this.signtime = signtime;
    }

    public Date getEndtime() {
        return endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCompanyname() {
        return companyname;
    }

    public void setCompanyname(String companyname) {
        this.companyname = companyname;
    }

    public String getPersonlevel() {
        return personlevel;
    }

    public void setPersonlevel(String personlevel) {
        this.personlevel = personlevel;
    }

    public Long getTrainorgid() {
        return trainorgid;
    }

    public void setTrainorgid(Long trainorgid) {
        this.trainorgid = trainorgid;
    }

    public Long getCompanyid() {
        return companyid;
    }

    public void setCompanyid(Long companyid) {
        this.companyid = companyid;
    }

    public String getStudystate() {
        return studystate;
    }

    public void setStudystate(String studystate) {
        this.studystate = studystate;
    }

    public String getTraintype() {
        return traintype;
    }

    public void setTraintype(String traintype) {
        this.traintype = traintype;
    }

    public Integer getVideonum() {
        return videonum;
    }

    public void setVideonum(Integer videonum) {
        this.videonum = videonum;
    }

    public Integer getStudyprogress() {
        return studyprogress;
    }

    public void setStudyprogress(Integer studyprogress) {
        this.studyprogress = studyprogress;
    }
}