package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;

import java.util.Map;

public class HMSDateExportWhereStrategy implements ExportWhereStrategy {
    @Override
    public String spliceWhereStr(SignType signType, Map<String, String> columnMap, Map<Object, Object> searchParams, Object key) {
        StringBuilder columnStr = new StringBuilder();
        //日期需要格式化处理
        columnStr.append(" and  date_format(")
                .append(columnMap.get(key))
                .append(",'%Y-%m-%d') ")
                .append(signType.getOperator())
                .append("date_format(")
                .append(searchParams.get(key))
                .append(",'%Y-%m-%d')");

        return columnStr.toString();
    }
}
