package com.bcxin.ars.enums;

/**
 * @author linqinglin
 * @date 2020/06/01 0001 13:22
 */
public enum SubsidyCerType {

    GRADE{
        @Override
        public String getCode(){return "01";}
        @Override
        public String getName(){return "等级证";}

        @Override
        public String getCName() {
            return "保安员职业技能培训补贴";
        }
    },
    QUALIFICATION{
        @Override
        public String getCode(){return "02";}
        @Override
        public String getName(){return "资格证";}

        @Override
        public String getCName() {
            return "保安员岗位资格培训补贴";
        }
    };

    public abstract String getCode();

    public abstract String getName();
    public abstract String getCName();

    public static SubsidyCerType getByCode(String code){
        switch (code){
            case "01":
                return GRADE;
            case "02":
                return QUALIFICATION;
            default:
                return GRADE;
        }
    }
}
