package com.bcxin.ars.enums;

import com.bcxin.ars.strategy.ministerial.*;

/**
 * @author linqinglin
 * @date 2021/03/06 0006 10:05
 */
public enum MinisterialDataFormat {


    /**
     * 默认
     */
    DEFAULT{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new DefaultMinDataFormatStrategy();
        }
    },
    /**
     * 是否有保安员证
     */
    HAVE_ZGCER{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new HaveCerMinDataFormatStrategy();
        }
    },

    /**
     * 性别
     */
    GENDER{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new GenderMinDataFormatStrategy();
        }
    },
    /**
     * 照片名
     */
    PHOTONAME{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new PhotoNameMinDataFormatStrategy();
        }
    },
    /**
     * 0,1 转2 ，1
     */
    BOOLEAN_CHANGE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new BooleanMinDataFormatStrategy();
        }
    },
    /**
     * 参军情况
     */
    ENROLLED{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new EnrolledMinDataFormatStrategy();
        }
    },
    /**
     * 文化程度
     */
    EDU{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new EduMinDataFormatStrategy();
        }
    },
    /**
     * 民族
     */
    NATION{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new NationMinDataFormatStrategy();
        }
    },
    /**
     * 国籍
     */
    NATIONAL{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new NationalMinDataFormatStrategy();
        }
    },
    /**
     * 出生日期
     */
    BIRTH{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new BirthMinDataFormatStrategy();
        }
    },

    /***
     * 证件类型
     */
    CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new CardTypeMinDataFormatStrategy();
        }
    },

    /***
     * 管理层证件类型
     */
    MANAGER_CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new ManagerMinDataFormatStrategy();
        }
    },

    /***
     * 股东证件类型
     */
    INVESTOR_CARD_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new InvestorCardTypeMinDataFormatStrategy();
        }
    },

    /***
     * 职业技能等级
     */
    JOB_LEVEL {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new JobLevelMinDataFormatStrategy();
        }
    },

    /***
     * 万元金额转元
     */
    AMOUNT{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new AmountFormatStrategy();
        }
    },
    /***
     * 服务范围
     */
    SECURITYSCOPETYPE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new SecurityScopeTypeFormatStrategy();
        }
    },
    /***
     * 公司类型
     */
    COMPANYTYPE{
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new CompanyTypeFormatStrategy();
        }
    },

    /**
     * 机构类型
     */
    INSTITUTION_TYPE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new InstitutionTypeMinDataFormatStrategy();
        }
    },

    /**
     * 机构类型转类型编码
     */
    INSTITUTION_TYPE_TO_CODE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new InstitutionTypeCodeMinDataFormatStrategy();
        }
    },

    /**
     * 公安机构代码
     */
    POLICE_ORG_CODE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new PoliceOrgCodeMinDataFormatStrategy();
        }
    },

    /**
     * 照片转base64
     */
    PHOTO_TO_BASE64 {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new PhotoMinDataFormatStrategy();
        }
    },

    /**
     * 出资金额比例小数占比转百分比
     */
    CONVERSION_TO_PERCENT {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new StockDataFormatStrategy();
        }
    },

    /**
     * 出资金额改元
     */
    CONVERSION_TO_YUAN {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new YuanDataFormatStrategy();
        }
    },

    /**
     * 去掉京公保服/号
     */
    REMOVE_CHINESE {
        @Override
        public MinDataFormatStrategy getMinDataFormatStrategy() {
            return new RemoveDataFormatStrategy();
        }
    }
    ;

    public abstract MinDataFormatStrategy getMinDataFormatStrategy();


}
