package com.bcxin.ars.dto.gx;

import com.bcxin.ars.model.gx.IntegratedApply;
import lombok.Data;
/**
 *
 * 广西公安互联网+平台与专业业务办理 流水号参数接口对象
 * @author subh
 * @since jdk1.8
 * @see IntegratedApply
 */
@Data
public class IntegratedApplyDto extends IntegratedApply {
    /***
     * 系统统一分配给接口使用方的身份标识，作为接口账号
     */
    private String key;
    /***
     * 系统统一分配给接口使用方的密钥，用于保证应用程序来源的可靠性，避免应用程序被伪造，作为接口密钥
     */
    private String secret;
    /***
     * 入参报文
     */
    private String xmlStr;
    /***
     * 公司名称
     */
    private String companyName;

    /**
     * 请求异常内容
     */
    private String exceptionContext;
}
