package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *sb_confesscompany
 *
 */
@Data
@ModelTableAnnotation
public class ConfesscompanyExportDTO extends BaseModel {

	/**  */
	private static final long serialVersionUID = -595513967313109389L;

	/**
    *名称
    */
	@ModelAnnotation(getName="名称",column = "Companyname",isExport = true,defaultColumn = true)
    private String companyname;
	/**
	 * 提交时间（审批表）
	 */
	@ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
	private Date createTime;
	/**
	 *法人姓名
	 */
	@ModelAnnotation(getName="法人姓名",column = "Legalname",isExport = true,defaultColumn = true)
	private String legalname;
	/**
	 *手机号码
	 */
	@ModelAnnotation(getName="手机号码",column = "Legalphone",isExport = true,defaultColumn = true)
	private String legalphone;
	/**
	 *审批状态
	 */
	@ModelAnnotation(getName="审批状态",column = "approvalstate",isExport = true,defaultColumn = true,needTranslate = true,dictName = "approvalState")
	private String approvalstate;
    /**
    *公司地址
    */
	@ModelAnnotation(getName="公司地址",column = "Address",isExport = true)
    private String address;

    /**
    *单位类型
    */
	@ModelAnnotation(getName="单位类型",column = "Companytype",isExport = true,needTranslate = true,dictName = "companyType")
    private String companytype;


	/**
	 *备案单位名称
	 */
	@ModelAnnotation(getName="备案单位名称",column = "Recordcompanyname",isExport = true)
	private String recordcompanyname;

	/**
	 *备案单位服务区域
	 */
	@ModelAnnotation(getName="备案单位服务区域",column = "Recordarea",isExport = true)
	private String recordarea;

	/**
	 *备案单位保安员数
	 */
	@ModelAnnotation(getName="备案单位保安员数",column = "Recordperonnum",isExport = true)
	private Integer recordperonnum;


	/**
	 * 安保范围
	 */
	@ModelAnnotation(getName="安保范围",column = "management",isExport = true,needTranslate = true,oneToMore = true,dictName = "securityScopeType")
	private String management;



	/**
    *邮编
    */
	@ModelAnnotation(getName="邮编",column = "Zipcode",isExport = true)
    private String zipcode;

    /**
    *统一信用代码
    */
	@ModelAnnotation(getName="统一信用代码",column = "Creditcode",isExport = true)
    private String creditcode;

    /**
    *单位员工数
    */
	@ModelAnnotation(getName="单位员工数",column = "Personnum",isExport = true)
    private Integer personnum;



    /**
    *法人性别
    */
	@ModelAnnotation(getName="法人性别",column = "Legalsex",isExport = true,needTranslate = true,dictName = "sex")
    private String legalsex;

    /**
    *法人民族
    */
	@ModelAnnotation(getName="法人民族",column = "Legalnation",isExport = true,needTranslate = true,dictName = "nation")
    private String legalnation;

    /**
    *法人出生年月
    */
	@ModelAnnotation(getName="法人出生年月",column = "Legalbirth",isExport = true)
    private Date legalbirth;

    /**
    *法人政治面貌
    */
	@ModelAnnotation(getName="法人政治面貌",column = "legalPolitics",isExport = true,needTranslate = true,dictName = "politics")
    private String legalpolitics;

    /**
    *法人文化程度
    */
	@ModelAnnotation(getName="法人文化程度",column = "legalCulture",isExport = true,needTranslate = true,dictName = "edu")
    private String legalculture;

    /**
    *法人办公电话
    */
	@ModelAnnotation(getName="法人办公电话",column = "Legaltel",isExport = true)
    private String legaltel;



    /**
    *法人国籍
    */
	@ModelAnnotation(getName="法人国籍",column = "Legalnationality",isExport = true)
    private String legalnationality;

    /**
    *法人证件类型
    */
	@ModelAnnotation(getName="法人证件类型",column = "Legaltype",isExport = true,needTranslate = true,dictName = "idCardType")
    private String legaltype;

    /**
    *法人证件号码
    */
	@ModelAnnotation(getName="法人证件号码",column = "Legalcardnumber",isExport = true)
    private String legalcardnumber;

    /**
    *法人实际居住地址
    */
	@ModelAnnotation(getName="法人实际居住地址",column = "Legaladdress",isExport = true)
    private String legaladdress;

    /**
    *法人户籍所在址/境外地址
    */
	@ModelAnnotation(getName="法人户籍所在址/境外地址",column = "legalAbroadaddress",isExport = true)
    private String legalabroadaddress;

    /**
    *备案单位地址
    */
	@ModelAnnotation(getName="备案单位地址",column = "Recordaddress",isExport = true)
    private String recordaddress;


    /**
    *备案单位持有保安员人数
    */
	@ModelAnnotation(getName="备案单位持有保安员人数",column = "recordnoperonnum",isExport = true)
    private Integer recordnoperonnum;

    /**
    *负责人姓名
    */
	@ModelAnnotation(getName="负责人姓名",column = "Chargename",isExport = true)
    private String chargename;

    /**
    *负责人职务
    */
	@ModelAnnotation(getName="负责人职务",column = "Chargepost",isExport = true)
    private String chargepost;

    /**
    *负责人居民身份证号码
    */
	@ModelAnnotation(getName="负责人居民身份证号码",column = "Chargecardnumber",isExport = true)
    private String chargecardnumber;

    /**
    *负责人联系电话
    */
	@ModelAnnotation(getName="负责人联系电话",column = "Chargephone",isExport = true)
    private String chargephone;

    /**
    *子公司保安人数
    */
	@ModelAnnotation(getName="子公司保安人数",column = "Sonpersonnum",isExport = true)
    private Integer sonpersonnum;

    /**
    *子公司邮编
    */
	@ModelAnnotation(getName="子公司邮编",column = "Sonzipcode",isExport = true)
    private String sonzipcode;

    /**
	 * 压缩包地址
	 */
	@ModelAnnotation(getName="压缩包地址",column = "template_rar")
	private String templateRar;
	
    /**
    *用户ID
    */
	@ModelAnnotation(getName="用户ID",column = "userid")
    private Long userid;



    /**
    *审批人
    */
	/*@ModelAnnotation(getName="审批人",column = "Approvalperson",isExport = true)*/
    private String approvalperson;

    /**
    *审批时间
    */
	/*@ModelAnnotation(getName="审批时间",column = "approvaldate",isExport = true)*/
    private Date approvaldate;

    /**
    *审批原因
    */
	/*@ModelAnnotation(getName="审批原因",column = "approvalreason",isExport = true)*/
    private String approvalreason;

	/**
	 * 审批信息列表
	 */
	private List approvallist;

	/***
	 * 保安许可服务证号
	 */
	@ModelAnnotation(getName="保安许可服务证号",column = "licencenum",isExport = true)
	private String licencenum;


	/**所在地省市县（区）**/
	@ModelAnnotation(getName="所在地省市县（区）",column = "szss",isExport = true)
	private String szss;

	/**所在地省代码**/
	@ModelAnnotation(getName="所在地省代码",column = "province")
	private String province;

	/**所在地市代码**/
	@ModelAnnotation(getName="所在地市代码",column = "city")
	private String city;

	/**所在地县（区）代码**/
	@ModelAnnotation(getName="所在地县（区）代码",column = "district",sign = SignType.LIKE)
	private String district;

	@ModelAnnotation(getName="区域代码",column = "district",sign = SignType.LIKE)
	private String areaCode;

    /**
     * 派出所ID
     */
	@ModelAnnotation(getName="派出所ID",column = "orgid")
    private Long orgid;

    
	/**
	 * 法人审核状态
	 */
	@ModelAnnotation(getName="法人审核状态",column = "legalcensorstatus",isExport = true,needTranslate = true,dictName = "censorStatus")
	private String legalcensorstatus;

	/**
	 *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
	 */
	@ModelAnnotation(getName="单位负责人审查状态",column = "chargecensorstatus",isExport = true,needTranslate = true,dictName = "censorStatus")
	private String chargecensorstatus;

	@ModelAnnotation(getName="公司编码",column = "companycode",isExport = true)
	private String companycode;

	@ModelAnnotation(getName="备案机构编码",column = "baorgcode",isExport = true)
	private String baorgcode;

	@ModelAnnotation(getName="备案机构名称",column = "baorgname",isExport = true)
	private String baorgname;

	@ModelAnnotation(getName="备案机构日期",column = "baorgdate",isExport = true)
	private Date baorgdate;

	private boolean isauto;


	/**
	 * 审批信息
	 */
	private Approval approval;

	/**
	 * 服务区域项目名称
	 */
	@ModelAnnotation(getName="服务区域项目名称",column = "serviceArea",isExport = true)
	private String serviceArea;

	/**
	 * 其他保安服务范围名称(保安范围为其他则此列必填)
	 */
	@ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType",isExport = true)
	private String otherSecScopeType;

	/**
	 * 其他公司类型名称(公司类型为其他则此列必填)
	 */
	@ModelAnnotation(getName="其他公司类型名称",column = "otherCompanyTypeName",isExport = true)
	private String otherCompanyTypeName;

}