package com.bcxin.ars.dto.exam;

import com.bcxin.ars.model.exam.TrainExamInfo;

/**
 * 考试基本信息DTO
 * 
 * @author zhangye
 * @version 1.0
 */
public class TrainExamInfoDto extends TrainExamInfo {

	private static final long serialVersionUID = -8341424619321910920L;

	/**
	 * 考试人数
	 */
	private int personCount;

	/**
	 * 未录入成绩人数
	 */
	private int notInScoreCount;

	/**
	 * 未发送考试通知人数
	 */
	private int notSendExamCount;

	/**
	 * 未发送成绩通知人数
	 */
	private int notSendScoreCount;

	/**
	 * 已发送考试通知人数
	 */
	private int examMessageState;

	/**
	 * 已发送成绩通知人数
	 */
	private int scoreMessageState;

	/**
	 * 机考开始时间(接收前端字符串日期格式)
	 */
	private String computerStartDateStr;

	/**
	 * 机考结束时间(接收前端字符串日期格式)
	 */
	private String computerEndDateStr;

	/**
	 * 体能测试开始时间(接收前端字符串日期格式)
	 */
	private String staminaStartDateStr;

	/**
	 * 体能测试结束时间(接收前端字符串日期格式)
	 */
	private String staminaEndDateStr;

	public int getPersonCount() {
		return personCount;
	}

	public void setPersonCount(int personCount) {
		this.personCount = personCount;
	}

	public int getNotInScoreCount() {
		return notInScoreCount;
	}

	public void setNotInScoreCount(int notInScoreCount) {
		this.notInScoreCount = notInScoreCount;
	}

	public int getNotSendExamCount() {
		return notSendExamCount;
	}

	public void setNotSendExamCount(int notSendExamCount) {
		this.notSendExamCount = notSendExamCount;
	}

	public int getNotSendScoreCount() {
		return notSendScoreCount;
	}

	public void setNotSendScoreCount(int notSendScoreCount) {
		this.notSendScoreCount = notSendScoreCount;
	}

	public String getComputerStartDateStr() {
		return computerStartDateStr;
	}

	public void setComputerStartDateStr(String computerStartDateStr) {
		this.computerStartDateStr = computerStartDateStr;
	}

	public String getComputerEndDateStr() {
		return computerEndDateStr;
	}

	public void setComputerEndDateStr(String computerEndDateStr) {
		this.computerEndDateStr = computerEndDateStr;
	}

	public String getStaminaStartDateStr() {
		return staminaStartDateStr;
	}

	public void setStaminaStartDateStr(String staminaStartDateStr) {
		this.staminaStartDateStr = staminaStartDateStr;
	}

	public String getStaminaEndDateStr() {
		return staminaEndDateStr;
	}

	public void setStaminaEndDateStr(String staminaEndDateStr) {
		this.staminaEndDateStr = staminaEndDateStr;
	}

	public int getExamMessageState() {
		return examMessageState;
	}

	public void setExamMessageState(int examMessageState) {
		this.examMessageState = examMessageState;
	}

	public int getScoreMessageState() {
		return scoreMessageState;
	}

	public void setScoreMessageState(int scoreMessageState) {
		this.scoreMessageState = scoreMessageState;
	}

}