package com.abcxin.smart.validator.annotation;

import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.enums.ImportType;

import java.lang.annotation.*;

/**
 * 内导外
 * @ClassName：com.abcxin.smart.validator.annotation
 * @author：linqinglin
 * @date：2019/04/03 9:32
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface DataSyncOutAnnotation {

    /**
     * 排序
     * @return
     */
    int getSeq() default  1000;

    /**
     * 实体类
     * @return
     */
    Class<?> getClazz();

    /**
     * 保存方法名
     */
    String getMethodName() default "importBatch";

    ImportType getImportType() default ImportType.BATCH;

    /**
     * 生成同步文件方法
     * @return
     */
    String getSearchMethodName() default "findDSOutList";
    /**
     * 同步或者异步执行
     * 默认异步
     * @return
     */
    SyncType getDataSyncType() default  SyncType.ASYNC;
}
