package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安服务公司信息实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "security_company",extraWhere = "AND institutionType='0102'")
public class Bagsxxb extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "companyCode")
    private String bagsbm;
    /**
     * 保安服务公司名称
     */
    @MinisterialAttr(column = "`name`")
    private String bagsmc;
    /**
     * 国籍（地区）
     */
    @MinisterialAttr(column = "(SELECT codeValue from sys_dict where codeType='nationality' and label  = t1.national)",defaultValue = "CHN",isSubQuery = true)
    private String gj;
    /**
     * 注册地省市县（区）
     */
    @MinisterialAttr(column = "areacode")
    private String zcd;
    /**
     * 注册地详址
     */
    @MinisterialAttr(column = "location")
    private String zcdxz;
    /**
     * 注册资金
     */
    @MinisterialAttr(column = "registered_money",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String zczj;
    /**
     * 法定代表人公民身份号码
     */
    @MinisterialAttr(column = "legalPersonNo")
    private String frsfzh;
    /**
     * 法定代表人姓名
     */
    @MinisterialAttr(column = "legal_person")
    private String frxm;
    /**
     * 法定代表人联系电话
     */
    @MinisterialAttr(column = "(SELECT u.phone from `user` u where u.id = t1.user_id)",isSubQuery = true)
    private String frdh;
    /**
     * 负责人公民身份号码
     */
    @MinisterialAttr(column = "principal_id")
    private String fzrsfzh;
    /**
     * 公司主要负责人姓名
     */
    @MinisterialAttr(column = "principal")
    private String fzrxm;
    /**
     * 公司主要负责人联系电话
     */
    @MinisterialAttr(column = "principal_phone")
    private String fzrdh;
    /**
     * 经济类型
     */
    @MinisterialAttr(column = "economic_type")
    private String jjlx;
    /**
     * 固定资产
     */
    @MinisterialAttr(column = "fixed_assets",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String gdzc;
    /**
     * 年营业额
     */
    @MinisterialAttr(column = "turnover_year",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String nyye;
    /**
     * 年利税
     */
    @MinisterialAttr(column = "annual_profits",DATA_FORMAT = MinisterialDataFormat.AMOUNT)
    private String nls;
    /**
     * 保安服务类型
     */
    @MinisterialAttr(column = "securityScopeType",DATA_FORMAT = MinisterialDataFormat.SECURITYSCOPETYPE)
    private String fwlx;
    /**
     * 公司类型
     * 1:国有资本；
     * 2：民营；
     * 3：外资（包括港澳台投资）；
     * 4：其他
     */
    @MinisterialAttr(column = "company_type",DATA_FORMAT = MinisterialDataFormat.COMPANYTYPE)
    private String gslx;
    /**
     * 保安服务许可证号
     */
    @MinisterialAttr(column = "public_security_license_number", DATA_FORMAT = MinisterialDataFormat.REMOVE_CHINESE)
    private String bafwxkz;
    /**
     * 保安服务许可证发证机关编码
     */
    private String fzjgbm;
    /**
     * 保安服务许可证发证机关名称
     */
    @MinisterialAttr(column = "give_license_name")
    private String fzjgmc;
    /**
     * 保安服务许可证发证日期
     */
    @MinisterialAttr(column = "give_license_date",DATE_FORMAT = "%Y%m%d")
    private String fzrq;
    /**
     * 保安服务许可证吊销机关
     */
    private String dxjg;
    /**
     * 保安服务许可证吊销日期
     */
    private String dxrq;
    /**
     * 人力防范等级
     */
    @MinisterialAttr(column = "human_defense_level",defaultValue = "0")
    private String rlffdj;
    /**
     * 武装守护押运等级
     */
    @MinisterialAttr(column = "armed_escort_level",defaultValue = "0")
    private String wzyydj;
    /**
     * 安全技术防范等级
     */
    @MinisterialAttr(column = "security_technology_level",defaultValue = "0")
    private String aqjsdj;
    /**
     * 风险评估等级
     */
    //@MinisterialAttr(column = "risk_assessment_level")
    private String fxpgdj;
    /**
     * 是否设立子公司
     */
    private String sfslzgs;
    /**
     * 子公司名称
     */
    private String zgsmc;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;
    /***
     * 客户数量
     */
    private  String khsl;
    /***
     * 变更标识 必填
     * 0：数据更新；
     * 1：名称变更；
     * 2：住所变更；
     * 3：法人变更；
     * 4：服务范围变更；
     */
    private String bgbs = "0";
    /***
     * 自建金库
     */
    private String zjjk;



    @Override
    public String toString() {
        return "Bagsxxb{" +
                "bagsbm='" + bagsbm + '\'' +
                ", bagsmc='" + bagsmc + '\'' +
                ", gj='" + gj + '\'' +
                ", zcd='" + zcd + '\'' +
                ", zcdxz='" + zcdxz + '\'' +
                ", zczj=" + zczj +
                ", frsfzh='" + frsfzh + '\'' +
                ", frxm='" + frxm + '\'' +
                ", frdh='" + frdh + '\'' +
                ", fzrsfzh='" + fzrsfzh + '\'' +
                ", fzrxm='" + fzrxm + '\'' +
                ", fzrdh='" + fzrdh + '\'' +
                ", jjlx='" + jjlx + '\'' +
                ", gdzc=" + gdzc +
                ", nyye=" + nyye +
                ", nls=" + nls +
                ", fwlx='" + fwlx + '\'' +
                ", gslx='" + gslx + '\'' +
                ", bafwxkz='" + bafwxkz + '\'' +
                ", fzjgbm='" + fzjgbm + '\'' +
                ", fzjgmc='" + fzjgmc + '\'' +
                ", fzrq=" + fzrq +
                ", dxjg='" + dxjg + '\'' +
                ", dxrq=" + dxrq +
                ", rlffdj=" + rlffdj +
                ", wzyydj=" + wzyydj +
                ", aqjsdj=" + aqjsdj +
                ", fxpgdj=" + fxpgdj +
                ", sfslzgs=" + sfslzgs +
                ", zgsmc='" + zgsmc + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
