package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安服务公司主要管理人员信息上报实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "sb_management_info", extraWhere = "and t1.user_id in (select security_company.user_id from security_company where institutionType = '0102')")
public class Bafwgsglry extends XxbaBaseDto {
    /**
     * 保安服务公司编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company where security_company.active = TRUE and security_company.USER_ID = t1.user_id)", isSubQuery = true)
    private String bagsbm;
    /**
     * 身份证号
     */
    @MinisterialAttr(column = "manager_id")
    private String sfzh;
    /**
     * 姓名
     */
    @MinisterialAttr(column = "`name`")
    private String xm;
    /**
     * 性别
     */
    @MinisterialAttr(column = "manager_id", DATA_FORMAT = MinisterialDataFormat.GENDER)
    private String xb;
    /**
     * 民族
     */
    @MinisterialAttr(column = "manage_nation")
    private String mz;
    /**
     * 出生日期
     */
    @MinisterialAttr(column = "manager_id",DATA_FORMAT = MinisterialDataFormat.BIRTH)
    private String csrq;
    /**
     * 国籍
     */
    private String gj;
    /**
     * 职务
     */
    @MinisterialAttr(column = "job_name")
    private String zw;
    /**
     * 职业技能等级
     */
    @MinisterialAttr(column = "job_level", DATA_FORMAT = MinisterialDataFormat.JOB_LEVEL)
    private String baydj;
    /**
     * 联系电话
     */
    @MinisterialAttr(column = "phone")
    private String lxdh;
    /**
     * 证件类型
     */
    @MinisterialAttr(column = "manager_license_type", DATA_FORMAT = MinisterialDataFormat.MANAGER_CARD_TYPE)
    private String gatlx;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Bafwgsglry{" +
                "bagsbm='" + bagsbm + '\'' +
                ", sfzh='" + sfzh + '\'' +
                ", xm='" + xm + '\'' +
                ", xb=" + xb +
                ", mz='" + mz + '\'' +
                ", csrq=" + csrq +
                ", gj='" + gj + '\'' +
                ", zw='" + zw + '\'' +
                ", baydj='" + baydj + '\'' +
                ", lxdh='" + lxdh + '\'' +
                ", gatlx='" + gatlx + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
