package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安从业单位及保安培训机构监督检查被处理人基本信息
 *
 * @author llc
 */
@Data
@MinisterialEntity(tableName = "person_punish")
public class Badwjdjcbclrxx extends XxbaBaseDto {
    /**
     * 保安单位编码
     */
    @MinisterialAttr(column = "(select companyCode from security_company sc where sc.user_id = userid)", isSubQuery = true)
    private String bagsbm;
    /**
     * 检查日期
     */
    @MinisterialAttr(column = "punish_date", DATE_FORMAT = "%Y%m%d")
    private String jcrq;
    /**
     * 被检查单位类型
     */
    @MinisterialAttr(column = "institutionType", DATA_FORMAT = MinisterialDataFormat.INSTITUTION_TYPE)
    private String jclx;
    /**
     * 被处理人员身份号码
     */
    @MinisterialAttr(column = "idnum")
    private String sfzh;
    /**
     * 被处理人职务
     */
    private String zw;
    /**
     * 处理结果
     */
    private String cljg;
    /**
     * 罚款金额
     */
    private String fkje;
    /**
     * 没收违法所得金额
     */
    private String mswfsdje;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Badwjdjcbclrxx{" +
                "bagsbm='" + bagsbm + '\'' +
                ", jcrq='" + jcrq + '\'' +
                ", jclx='" + jclx + '\'' +
                ", sfzh='" + sfzh + '\'' +
                ", zw='" + zw + '\'' +
                ", cljg='" + cljg + '\'' +
                ", fkje='" + fkje + '\'' +
                ", mswfsdje='" + mswfsdje + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
