package com.bcxin.ars.strategy.ministerial;

import com.abcxin.smart.validator.annotation.MinisterialAttr;

import java.lang.reflect.Field;

/**
 * 机构类型
 * @author zhangyutong
 */
public class InstitutionTypeMinDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        /*
        1：保安服务公司；
        2：自行招用保安员的单位；
        3：保安培训机构编码
        0102,保安服务公司
        0103,保安培训单位
        0104,自行招用保安单位

        */
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }

        if ("0102".equals(data)
                || "0105".equals(data)) {
            return "1";
        }

        if ("0104".equals(data)) {
            return "2";
        }

        if ("0103".equals(data)) {
            return "3";
        }
        return null;
    }
}
