package com.bcxin.ars.model.task;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

import java.util.ArrayList;
import java.util.List;

/**
 * 安保任务
 * @author Ethan
 */
public class Task extends BaseModel {

	private static final long serialVersionUID = 7769876577249818360L;

	/**
	 * 数据区域
	 */
	@ModelAnnotation(getName="数据区域",column = "native_code")
	private Long nativeCode;
	
	/**
	 * 所属公司
	 */
	@JsonIgnoreProperties(value={"handler"})
	private SecurityCompany company;
	
	/**
	 * 任务级别
	 */
	@JsonIgnoreProperties(value={"handler"})
	private TaskLevel taskLevel;
	
	/**
	 * 任务类型
	 */
	@JsonIgnoreProperties(value={"handler"})
	private TaskType taskType;
	
	/**
	 * 任务种类
	 */
	@JsonIgnoreProperties(value={"handler"})
	private TaskCatalog taskCatalog;
	
	/**
	 * 创建者
	 */
	@ModelAnnotation(getName="创建者",column = "creater")
	private String creater;
	
	/**
	 * 任务名称
	 */
	@ModelAnnotation(getName="任务名称",column = "name")
	private String name;
	
	/**
	 * 区域
	 */
	@ModelAnnotation(getName="区域",column = "area")
	private String area;
	
	/**
	 * 任务地点
	 */
	@ModelAnnotation(getName="任务地点",column = "address")
	private String address;
	
	/**
	 * 地点经度
	 */
	@ModelAnnotation(getName="地点经度",column = "longitude")
	private String longitude;
	
	/**
	 * 地点纬度
	 */
	@ModelAnnotation(getName="地点纬度",column = "latitude")
	private String latitude;
	
	/**
	 * 半径范围
	 */
	@ModelAnnotation(getName="半径范围",column = "scope")
	private Integer scope;
	
	/**
	 * 任务明细
	 */
	@ModelAnnotation(getName="任务明细",column = "detail")
	private String detail;

	/**
	 * 紧急类型 1 自然灾害 2 事故灾难 3 公共卫生事件 4 社会安全事件
	 */
	@ModelAnnotation(getName="紧急类型",column = "urgenttype")
	private String urgenttype;
	/***
	 * 紧急程度 1 一般 2 较大 3 重大 4 特别重大
	 */
	@ModelAnnotation(getName="紧急程度",column = "urgentdegree")
	private String urgentdegree;
	/**
	 * 需要人数
	 */
	@ModelAnnotation(getName="需要人数",column = "neednum")
	private Integer neednum;
	/**
	 * 人员类型
	 * */
	@ModelAnnotation(getName="人员类型",column = "peopletype")
	private String peopletype;

	/**
	 * 紧急任务推送的次数
	 */
	@ModelAnnotation(getName="紧急任务推送的次数",column = "sendcount")
	private Integer sendcount;

	/**
	 * 任务状态
	 */
	@JsonIgnoreProperties(value={"handler"})
	private TaskStatus taskStatus;
	
	/**
	 * 开始日期
	 */
	@ModelAnnotation(getName="开始日期",column = "start_date")
	private String startDate;
	
	/**
	 * 结束日期
	 */
	@ModelAnnotation(getName="结束日期",column = "end_time")
	private String endDate;
	
	/**
	 * true=固定班次/false=排班制
	 */
	private boolean isRepeat;
	
	/**
	 * 自动过滤节假日
	 */
	private boolean autoHoliday = true;


	/***
	 * 区域
	 */
	@ModelAnnotation(getName="区域",column = "areacode")
	private String areacode;
	/**
	 * 任务全体人员列表，包括排班信息
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<TaskPerson> personList = new ArrayList<TaskPerson>();
	
	/**
	 * 任务班次
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<SecurityCompanySchedule> scheduleList = new ArrayList<SecurityCompanySchedule>();

	/**
	 * 子任务详情
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<TaskFeedback> feedbackList = new ArrayList<TaskFeedback>();

	/**数据迁移关联的外网id **/
	private Long rawid;
	
	/**数据迁移关联的内网id **/
	private Long inrawid;

	private Integer company_id;
	private Integer task_level;
	private Integer task_type;
	private Integer task_catalog;
	private Integer task_status;

	/**当前任务状态(非数据库字段)*/
	private String currentTaskStatus;//1:正在执行,2:已完成,3:已结束,4:新任务,5:即将进行,6已拒绝，7.已过期
	
	public Integer getCompany_id() {
		return company_id;
	}

	public void setCompany_id(Integer company_id) {
		this.company_id = company_id;
	}

	public Integer getTask_level() {
		return task_level;
	}

	public void setTask_level(Integer task_level) {
		this.task_level = task_level;
	}

	public Integer getTask_type() {
		return task_type;
	}

	public void setTask_type(Integer task_type) {
		this.task_type = task_type;
	}

	public Integer getTask_catalog() {
		return task_catalog;
	}

	public void setTask_catalog(Integer task_catalog) {
		this.task_catalog = task_catalog;
	}

	public Integer getTask_status() {
		return task_status;
	}

	public void setTask_status(Integer task_status) {
		this.task_status = task_status;
	}

	public String getAreacode() {
		return areacode;
	}

	public void setAreacode(String areacode) {
		this.areacode = areacode;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public SecurityCompany getCompany() {
		return company;
	}

	public void setCompany(SecurityCompany company) {
		this.company = company;
	}

	public TaskLevel getTaskLevel() {
		return taskLevel;
	}

	public void setTaskLevel(TaskLevel taskLevel) {
		this.taskLevel = taskLevel;
	}

	public TaskType getTaskType() {
		return taskType;
	}

	public void setTaskType(TaskType taskType) {
		this.taskType = taskType;
	}

	public TaskCatalog getTaskCatalog() {
		return taskCatalog;
	}

	public void setTaskCatalog(TaskCatalog taskCatalog) {
		this.taskCatalog = taskCatalog;
	}

	public String getCreater() {
		return creater;
	}

	public void setCreater(String creater) {
		this.creater = creater;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public Integer getScope() {
		return scope;
	}

	public void setScope(Integer scope) {
		this.scope = scope;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public TaskStatus getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(TaskStatus taskStatus) {
		this.taskStatus = taskStatus;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public boolean isRepeat() {
		return isRepeat;
	}

	public void setRepeat(boolean isRepeat) {
		this.isRepeat = isRepeat;
	}

	public boolean isAutoHoliday() {
		return autoHoliday;
	}

	public void setAutoHoliday(boolean autoHoliday) {
		this.autoHoliday = autoHoliday;
	}

	public List<TaskPerson> getPersonList() {
		return personList;
	}

	public void setPersonList(List<TaskPerson> personList) {
		this.personList = personList;
	}

	public List<SecurityCompanySchedule> getScheduleList() {
		return scheduleList;
	}

	public void setScheduleList(List<SecurityCompanySchedule> scheduleList) {
		this.scheduleList = scheduleList;
	}

	public List<TaskFeedback> getFeedbackList() {
		return feedbackList;
	}

	public void setFeedbackList(List<TaskFeedback> feedbackList) {
		this.feedbackList = feedbackList;
	}

	public String getPeopletype() {
		return peopletype;
	}

	public void setPeopletype(String peopletype) {
		this.peopletype = peopletype;
	}

	public String getUrgenttype() {
		return urgenttype;
	}

	public void setUrgenttype(String urgenttype) {
		this.urgenttype = urgenttype;
	}

	public String getUrgentdegree() {
		return urgentdegree;
	}

	public void setUrgentdegree(String urgentdegree) {
		this.urgentdegree = urgentdegree;
	}

	public Integer getNeednum() {
		return neednum;
	}

	public void setNeednum(Integer neednum) {
		this.neednum = neednum;
	}

	public Integer getSendcount() {
		return sendcount;
	}

	public void setSendcount(Integer sendcount) {
		this.sendcount = sendcount;
	}

	public Long getRawid() {
		return rawid;
	}

	public void setRawid(Long rawid) {
		this.rawid = rawid;
	}

	public Long getInrawid() {
		return inrawid;
	}

	public void setInrawid(Long inrawid) {
		this.inrawid = inrawid;
	}

	public String getCurrentTaskStatus() {
		return currentTaskStatus;
	}

	public void setCurrentTaskStatus(String currentTaskStatus) {
		this.currentTaskStatus = currentTaskStatus;
	}

}
