package com.bcxin.ars.model.task;

import lombok.Data;
import java.util.Date;
import com.bcxin.ars.model.BaseModel;


/**
 * 临保任务对象
 *
 * @table com_temp_task
 * @author lin
 * @date 2021-02-01
 */
@Data
public class ComTempTask extends BaseModel{

    private static final long serialVersionUID=1L;

    
    /**
     * 临保任务ID
     */
    private Long comTempTaskId;
            
    /**
     * 创建人ID
     */
    private Long userId;
                    
    /**
     * 任务名称
     */
    private String taskName;
        
    /**
     * 任务类型
     */
    private String taskType;
        
    /**
     * 驻勤点类型
     */
    private String taskStationType;
        
    /**
     * 服务对象
     */
    private String serviceObject;
        
    /**
     * 服务对象类型
     */
    private String serviceObjectType;
        
    /**
     * 服务对象涉外情况
     */
    private String serviceObjectSySituation;
        
    /**
     * 是否治安保卫重点单位
     */
    private String securityImportantUnit;
        
    /**
     * 任务内容
     */
    private String taskContent;
        
    /**
     * 任务地址所在省份
     */
    private String province;
        
    /**
     * 任务地区
     */
    private String areaName;
        
    /**
     * 任务地区code
     */
    private String area;
        
    /**
     * 任务地址
     */
    private String taskAddress;
        
    /**
     * 任务地址经度
     */
    private String addressLongitude;
        
    /**
     * 任务地址纬度
     */
    private String addressLatitude;
        
    /**
     * 执行范围（单位:米）
     */
    private Long execRange;
        
    /**
     * 任务状态
     */
    private String taskStatus;
        
    /**
     * 任务开始日期
     */
    private Date startDate;
        
    /**
     * 任务截止日期
     */
    private Date endDate;
        
    /**
     * 任务负责人ID
     */
    private Long chargePerId;
        
    /**
     * 企业合同ID
     */
    private Long comContractId;
        
    /**
     * 监管机构id
     */
    private Long orgId;
        
    /**
     * 监管机构名称
     */
    private String orgName;
            
    /**
     * 企业ID
     */
    private Long comId;
    
    @Override
    public boolean equals(Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComTempTask that = (ComTempTask) o;
            if (that.getId() != null && this.getId() != null){
                if (that.getComTempTaskId().intValue() == this.getComTempTaskId().intValue() && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
