package com.bcxin.ars.model.task;

import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 驻勤点（任务）
 */
@Data
@ModelTableAnnotation(tableName = "com_task",getName = "驻勤点")
public class ComTask extends BaseModel {

    /** 任务ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comTaskId;

    /** 是否逻辑删除 */
    private String isDelete;

    /** 任务名称 */
    private String taskName;

    /** 任务类型 */
    private String taskType;

    /** 驻勤点类型 */
    private String taskStationType;

    /** 服务对象 */
    private String serviceObject;

    /** 服务对象涉外情况 */
    private String serviceObjectSySituation;

    /** 任务内容 */
    private String taskContent;

    /** 任务地址所在省份 */
    private Integer province;

    /** 任务地址所在城市 */
    private Integer city;

    /** 任务地址所在区县 */
    private Integer area;

    /** 任务地址 */
    private String taskAddress;

    /** 任务精确地址 */
    private String taskExactAddress;

    /** 执行范围（单位:米） */
    private Long execRange;

    /** 任务状态 */
    private String taskStatus;
    private String taskStatusNew;

    /** 任务开始日期 */
    private Date startDate;

    /** 任务截止日期 */
    private Date endDate;

    /** 人数 */
    private Long perNum;
    /**
     * 已投保人数
     */
    private Long insuredNumber;
    /**
     * 在岗保安员数量
     */
    private Integer onDutyPersons;

    /***
     * 机构ID（saas那边传过来的）
     */
    private Long bbdId;

    /***
     * 机构ID
     */
    private Long orgId;
    /***
     * 机构名称
     */
    private String orgName;

    /** 企业ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 任务合同关联 */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comContractId;

    /**
     * 合同状态
     */
    private String contractStatus;

    /**
     * 任务安排人员
     */
    private List<ComTaskPer> perList;

    /**
     * 勿删
     * @param o
     * @return
     */
    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            ComTask that = (ComTask) o;
            if (that.getComTaskId() != null && this.getComTaskId() != null){
                if (that.getComTaskId().intValue() == this.getComTaskId().intValue() && that.getUpdateTime().getTime() >= this.getUpdateTime().getTime()) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    /**
     * 勿删
     * @return
     */
    @Override
    public int hashCode() {
        return getId().hashCode();
    }
}