package com.bcxin.ars.model.sx;

import lombok.Data;

import java.util.Date;
@Data
public class StepBasicinfo {
    /** 主键，原系统中具体数据的唯一ID  */
    private String orgbusno;

    /** 主键，详见附录2.3 */
    private String projid;

    /** 主键，默认为1，用于重报数据的情况。 */
    private String dataver;

    /** 由省级政务服务平台随机自动生成的数字，如：234765  */
    private String projpwd;

    /** 编码规则见附录2.4 */
    private String region_id;

    /** 详见附录2.1 */
    private String item_code;

    /** 详见附录2.2 */
    private String implement_code;

    /** 事项所属行政区划，编码规则见附录2.4 */
    private String itemregionid;

    /** 事项主项名称 */
    private String itemname;

    /** 若审批事项，不按大小项分，则子项名称等于审批事项名称（可为空） */
    private String subitemname;

    /** 申请审批的项目的具体名称。如：关于XXX的交通建设工程施工许可 */
    private String projectname;

    /** GB/T 19488.2-2008中姓名或机构名称 */
    private String applicant;

    /** GB/T 19488.2-2008中移动电话 */
    private String applicantmobile;

    /** GB/T 19488.2-2008中联系电话 */
    private String applicanttel;

    /** GB/T 19488.2-2008中电子信箱 */
    private String applicantemail;

    /** 受理单位名称 */
    private String acceptdeptname;

    /** GB 32100-2015中统一社会信用代码 */
    private String acceptdeptid;

    /** 若没有则填无 */
    private String acceptdeptcode1;

    /** 若没有则填无 */
    private String acceptdeptcode2;

    /** 1-即办件，2-承诺件，3-联办件，4-上报件。 */
    private String approvaltype;

    /** 承诺时限 */
    private String promisetimelimit;

    /** 1-工作日；2-自然日；3-小时；4-分钟；5-月 */
    private String  promisetimeunit;

    /** 按法律、法规规定的办理此项审批事项的时限。 */
    private Short timelimit;

    /** 规定办理时限的单位（年、月的情况需要换算成天，1年等于365天，1个月等于30天）：G – 工作日（不包含法定节假日）Z – 自然日 */
    private String timeunit;

    /** 0-窗口提交，1-网上提交，2-信函,3-电报，4-电传，5-传真，6-邮件,7-电子数据交换，8-其他 */
    private String submit;

    /** GB/T 19488.2-2008中日期时间 */
    private Date occurtime;

    /** GB/T 19488.2-2008中姓名 */
    private String transactor;

    /** 投资项目并联相关，非投资项目并联事项可空 */
    private String project_code;

    /** 进入数据库时间，默认为系统时间 */
    private Date maketime;

    /** 数据交换状态标志位，默认为0 */
    private Long signstate;

    /** V3 */
    private String errorcode1;

    /** V3 */
    private String errormsg1;

    /** V3数据状态：0=未交换；1=正确交换；9=异常 */
    private String status1;

    /** 系统标识,非空 */
    private String sysmark;

    /**  */
    private Date localtime;

    /**  同步类型 I-插入，U-更新，D-删除 */
    private String cd_operation;

    /**  业务办理项编码 */
    private String taskhandleitem;

    /** 国家平台基本编码 根据国家平台规范修改。见C0109.1 中的第4章 */
    private String coucatalogcode;

    /**  国家平台实施编码 根据国家平台规范修改。见C0109.1 中的第5章 */
    private String coutaskcode;

    /** 申请人类型 见C0126.1 附录C.9服务对象*/
    private String applyertype;

    /**  受理文书编号 根据国家平台规范添加*/
    private String acceptdocno;

    /** 承诺办结时间 */
    private Date promisedate;

    /** 事项标记 */
    private String sourceid;

    /**  */
    private String acceptlist;

}