package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;
import lombok.Data;

import java.util.Date;


/**
 * sb_traincompanyapply
 */
@Data
public class Traincompanyapply extends BusinessCommon {

    /**  */
	private static final long serialVersionUID = -1353450017808828069L;

    /**
     * 公司用房面积
     */
    @ModelAnnotation(getName="公司用房面积",column = "company_house_area",isExport = true)
    private String companyHoseArea;

    /**
     * 地址
     */
    @ModelAnnotation(getName="地址",column = "address",isExport = true)
    private String address;

    /**
     * 姓名
     */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true)
    private String name;

    /**
     * 拟任职务
     */
    @ModelAnnotation(getName="拟任职务",column = "post",isExport = true)
    private String post;

    /**
     * 性别
     */
    @ModelAnnotation(getName="性别",column = "sex",isExport = true,needTranslate = true,dictName = "sex")
    private String sex;

    /**
     * 民族
     */
    @ModelAnnotation(getName="民族",column = "Nation",isExport = true)
    private String nation;

    /**
     * 出生年月
     */
    @ModelAnnotation(getName="出生年月",column = "birth",isExport = true)
    private Date birth;

    /**
     * 政治面貌
     */
    @ModelAnnotation(getName="政治面貌",column = "politics",isExport = true)
    private String politics;

    /**
     * 文化程度
     */
    @ModelAnnotation(getName="文化程度",column = "culture",isExport = true)
    private String culture;

    /**
     * 联系电话
     */
    @ModelAnnotation(getName="联系电话",column = "phone",isExport = true)
    private String phone;

    /**
     * 籍贯
     */
    @ModelAnnotation(getName="籍贯",column = "place",isExport = true)
    private String place;

    /**
     * 职业资质
     */
    @ModelAnnotation(getName="职业资质",column = "qualifications",isExport = true)
    private String qualifications;

    /**
     * 技术职称
     */
    @ModelAnnotation(getName="技术职称",column = "title",isExport = true)
    private String title;

    /**
     * 法定代表人姓名
     */
    @ModelAnnotation(getName="法定代表人姓名",column = "legalname",isExport = true)
    private String legalname;

    /**
     * 居民身份证
     */
    @ModelAnnotation(getName="居民身份证",column = "creditcode",isExport = true)
    private String creditcode;

    /**
     * 邮政编码
     */
    @ModelAnnotation(getName="邮政编码",column = "zipcode",isExport = true)
    private String zipcode;

    /**
     * 组织机构代码
     */
    @ModelAnnotation(getName="组织机构代码",column = "organizationcode",isExport = true)
    private String organizationcode;

    /**
     * 单位性质
     */
    @ModelAnnotation(getName="单位性质",column = "companytype",isExport = true)
    private String companytype;

    /**
     * 保安服务许可证编号
     */
    @ModelAnnotation(getName="保安服务许可证编号",column = "allownumber",isExport = true)
    private String allownumber;

    /**
     * 营业执照编号
     */
    @ModelAnnotation(getName="营业执照编号",column = "businessnumber",isExport = true)
    private String businessnumber;

    /**
     * 批准机关及文号
     */
    @ModelAnnotation(getName="批准机关及文号",column = "organsallownumber",isExport = true)
    private String organsallownumber;

    /**
     * 保安培训机构名称
     */
    @ModelAnnotation(getName="保安培训机构名称",column = "traincompanyname",isExport = true,defaultColumn=true)
    private String traincompanyname;

    /**
     * （保安培训机构）法人姓名
     */
    @ModelAnnotation(getName="（保安培训机构）法人姓名",column = "trainlegalname",isExport = true,defaultColumn=true)
    private String trainlegalname;

    /**
     * （保安培训机构）身份证
     */
    @ModelAnnotation(getName=" （保安培训机构）身份证",column = "traincreditcode",isExport = true,defaultColumn=true)
    private String traincreditcode;

    /**
     * (保安培训机构)手机号
     */
    @ModelAnnotation(getName=" (保安培训机构)手机号",column = "trainphone",isExport = true,defaultColumn=true)
    private String trainphone;

    /**
     * (保安培训机构)地址
     */
    @ModelAnnotation(getName="(保安培训机构)地址",column = "trainaddress",isExport = true)
    private String trainaddress;

    /**
     * （保安培训机构）邮编
     */
    @ModelAnnotation(getName=" （保安培训机构）邮编",column = "trainzipcode",isExport = true)
    private String trainzipcode;

    /**
     * 保安培训机构规模
     */
    @ModelAnnotation(getName="保安培训机构规模",column = "trainsize",isExport = true)
    private String trainsize;

    /**
     * (保安培训机构)培训内容
     */
    @ModelAnnotation(getName="(保安培训机构)培训内容",column = "traincontent",isExport = true)
    private String traincontent;


    /***
     * 现法人身份证号
     */
    @ModelAnnotation(getName="现法人身份证号",column = "legalcode",isExport = true)
    private String legalcode;

    /***
     * 现法人手机
     */
    @ModelAnnotation(getName="现法人手机",column = "legalphone",isExport = true)
    private String legalphone;

    /**
     * 审查状态 0未审查 003 审查通过 004 审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "censor_status",isExport = true,defaultColumn=true)
    private String censorStatus;

    /**
     * 审查状态 0未审查 1 审查通过 2审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "plan_censor_status",isExport = true)
    private String planCensorStatus;

    /**
     * 资料补正告知书
     */
    @ModelAnnotation(getName="资料补正告知书",column = "info_rar")
    private String infoRar;

    /**
     * 批复意见
     * @return
     */
    @ModelAnnotation(getName="批复意见",column = "replyreason")
    private String replyreason;
    /***
     * 批复附件
     */
    @ModelAnnotation(getName="批复附件",column = "reply_rar")
    private String replyRar;
    /***
     * 批复结果
     */
    @ModelAnnotation(getName="批复结果",column = "reply_state")
    private String replyState;

    /**
     *制证状态    2已制证  0未制证  1提交审核
     */
    @ModelAnnotation(getName="开始时间",column = "card_state",isExport = true)
    private String cardState;

    /**
     * 批复，上传，制证按钮的标志位，在新审批中显示，旧审批中不显示
     * 1代表旧审批  空代表新审批
     */
    private String newOldFlag;

    /**
     * 上传承诺书的路径
     */
    private String permitPath;

    /**
     * 上传签字承诺书视频的路径
     */
    private String permitVideoPath;

    public String getPermitPath() {
        return permitPath;
    }

    public void setPermitPath(String permitPath) {
        this.permitPath = permitPath;
    }


    public String getNewOldFlag() {
        return newOldFlag;
    }

    public void setNewOldFlag(String newOldFlag) {
        this.newOldFlag = newOldFlag;
    }

    public String getCardState() {
        return cardState;
    }

    public void setCardState(String cardState) {
        this.cardState = cardState;
    }

    public String getReplyState() {
        return replyState;
    }

    public void setReplyState(String replyState) {
        this.replyState = replyState;
    }

    public String getReplyRar() {
        return replyRar;
    }

    public void setReplyRar(String replyRar) {
        this.replyRar = replyRar;
    }

    public String getReplyreason() {
        return replyreason;
    }

    public void setReplyreason(String replyreason) {
        this.replyreason = replyreason;
    }

    public String getInfoRar() {
        return infoRar;
    }

    public void setInfoRar(String infoRar) {
        this.infoRar = infoRar;
    }

    public String getLegalname() {
        return legalname;
    }

    public void setLegalname(String legalname) {
        this.legalname = legalname;
    }

    public String getCreditcode() {
        return creditcode;
    }

    public void setCreditcode(String creditcode) {
        this.creditcode = creditcode;
    }

    public String getZipcode() {
        return zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getOrganizationcode() {
        return organizationcode;
    }

    public void setOrganizationcode(String organizationcode) {
        this.organizationcode = organizationcode;
    }

    public String getCompanytype() {
        return companytype;
    }

    public void setCompanytype(String companytype) {
        this.companytype = companytype;
    }

    public String getAllownumber() {
        return allownumber;
    }

    public void setAllownumber(String allownumber) {
        this.allownumber = allownumber;
    }

    public String getBusinessnumber() {
        return businessnumber;
    }

    public void setBusinessnumber(String businessnumber) {
        this.businessnumber = businessnumber;
    }

    public String getOrgansallownumber() {
        return organsallownumber;
    }

    public void setOrgansallownumber(String organsallownumber) {
        this.organsallownumber = organsallownumber;
    }

    public String getTraincompanyname() {
        return traincompanyname;
    }

    public void setTraincompanyname(String traincompanyname) {
        this.traincompanyname = traincompanyname;
    }

    public String getTrainlegalname() {
        return trainlegalname;
    }

    public void setTrainlegalname(String trainlegalname) {
        this.trainlegalname = trainlegalname;
    }

    public String getTraincreditcode() {
        return traincreditcode;
    }

    public void setTraincreditcode(String traincreditcode) {
        this.traincreditcode = traincreditcode;
    }

    public String getTrainphone() {
        return trainphone;
    }

    public void setTrainphone(String trainphone) {
        this.trainphone = trainphone;
    }

    public String getTrainaddress() {
        return trainaddress;
    }

    public void setTrainaddress(String trainaddress) {
        this.trainaddress = trainaddress;
    }

    public String getTrainzipcode() {
        return trainzipcode;
    }

    public void setTrainzipcode(String trainzipcode) {
        this.trainzipcode = trainzipcode;
    }

    public String getTrainsize() {
        return trainsize;
    }

    public void setTrainsize(String trainsize) {
        this.trainsize = trainsize;
    }

    public String getTraincontent() {
        return traincontent;
    }

    public void setTraincontent(String traincontent) {
        this.traincontent = traincontent;
    }

    /**
     * 地址
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * 地址
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 姓名
     */
    public String getName() {
        return this.name;
    }

    /**
     * 姓名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 拟任职务
     */
    public String getPost() {
        return this.post;
    }

    /**
     * 拟任职务
     */
    public void setPost(String post) {
        this.post = post;
    }

    /**
     * 性别
     */
    public String getSex() {
        return this.sex;
    }

    /**
     * 性别
     */
    public void setSex(String sex) {
        this.sex = sex;
    }

    /**
     * 民族
     */
    public String getNation() {
        return this.nation;
    }

    /**
     * 民族
     */
    public void setNation(String nation) {
        this.nation = nation;
    }

    /**
     * 出生年月
     */
    public Date getBirth() {
        return this.birth;
    }

    /**
     * 出生年月
     */
    public void setBirth(Date birth) {
        this.birth = birth;
    }

    /**
     * 政治面貌
     */
    public String getPolitics() {
        return this.politics;
    }

    /**
     * 政治面貌
     */
    public void setPolitics(String politics) {
        this.politics = politics;
    }

    /**
     * 文化程度
     */
    public String getCulture() {
        return this.culture;
    }

    /**
     * 文化程度
     */
    public void setCulture(String culture) {
        this.culture = culture;
    }

    /**
     * 联系电话
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * 联系电话
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 籍贯
     */
    public String getPlace() {
        return this.place;
    }

    /**
     * 籍贯
     */
    public void setPlace(String place) {
        this.place = place;
    }

    /**
     * 职业资质
     */
    public String getQualifications() {
        return this.qualifications;
    }

    /**
     * 职业资质
     */
    public void setQualifications(String qualifications) {
        this.qualifications = qualifications;
    }

    /**
     * 技术职称
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * 技术职称
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 产权归属
     */
    public String ascription;

    /**
     * 专用运输车辆数
     */
    public Integer ascriptionvehicle;

    /**
     * 防爆枪支数
     */
    public Integer gunnum;

    public String getAscription() {
        return ascription;
    }

    public void setAscription(String ascription) {
        this.ascription = ascription;
    }

    public Integer getAscriptionvehicle() {
        return ascriptionvehicle;
    }

    public void setAscriptionvehicle(Integer ascriptionvehicle) {
        this.ascriptionvehicle = ascriptionvehicle;
    }

    public Integer getGunnum() {
        return gunnum;
    }

    public void setGunnum(Integer gunnum) {
        this.gunnum = gunnum;
    }

    public String getLegalphone() {
        return legalphone;
    }

    public void setLegalphone(String legalphone) {
        this.legalphone = legalphone;
    }

    public String getLegalcode() {

        return legalcode;
    }

    public void setLegalcode(String legalcode) {
        this.legalcode = legalcode;
    }

	public String getCensorStatus() {
		return censorStatus;
	}

	public void setCensorStatus(String censorStatus) {
		this.censorStatus = censorStatus;
	}

	public String getPlanCensorStatus() {
		return planCensorStatus;
	}

	public void setPlanCensorStatus(String planCensorStatus) {
		this.planCensorStatus = planCensorStatus;
	}

    public String getCompanyHoseArea() {
        return companyHoseArea;
    }

    public void setCompanyHoseArea(String companyHoseArea) {
        this.companyHoseArea = companyHoseArea;
    }
}