package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;
import lombok.Data;

import java.util.Date;

/**
 * sb_sponsorlicense
 * 保安服务公司许可证审批
 */
@Data
public class Sponsorlicense extends BusinessCommon {


    /**  */
	private static final long serialVersionUID = -4246009296182842092L;

    /**
     * 创建时间
     */
    @ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true)
    private Date createTime;


    /**
     * 创建时间
     */
    @ModelAnnotation(getName="修改时间",column = "update_time",isExport = true,defaultColumn=true)
    private Date updateTime;


    /**
     * 电话
     */
    @ModelAnnotation(getName="电话",column = "Tel",isExport = true)
    private String tel;

    /**
     * 公司地址
     */
    @ModelAnnotation(getName="法人身份证正面",column = "Address",isExport = true)
    private String address;

    /**
     * 邮编
     */
    @ModelAnnotation(getName="邮编",column = "Zipcode",isExport = true)
    private String zipcode;

    /**
     * 经营范围
     */
    @ModelAnnotation(getName="经营范围",column = "management",isExport = true,needTranslate = true,oneToMore = true,dictName ="securityScopeType")
    private String management;

    /**
     * 企业类型
     */
    @ModelAnnotation(getName="企业类型",column = "Enterprisetype",isExport = true)
    private String enterprisetype;

    /**
     * 注册资本
     */
    @ModelAnnotation(getName="注册资本",column = "Regcapital",isExport = true)
    private Integer regcapital;

    /**
     * 注册资本验资或评估机构
     */
    @ModelAnnotation(getName="注册资本验资或评估机构",column = "Assessmentorg",isExport = true)
    private String assessmentorg;

    /**
     * 货币资本
     */
    @ModelAnnotation(getName="货币资本",column = "currency",isExport = true)
    private Integer currency;

    /**
     * 货币资本百分比
     */
    @ModelAnnotation(getName="货币资本百分比",column = "currencybf",isExport = true)
    private String currencybf;
    /**
     * 货币评估资本百分比
     */
    @ModelAnnotation(getName="货币评估资本百分比",column = "currencyvaluebf",isExport = true)
    private String currencyvaluebf;

    /**
     *货币评估资本
     */
    @ModelAnnotation(getName="货币评估资本",column = "currencyvalue",isExport = true)
    private Integer currencyvalue;

    /**
     * 法人姓名
     */
    @ModelAnnotation(getName="法人姓名",column = "Representative",isExport = true,defaultColumn=true)
    private String representative;

    /**
     *法人代表手机号
     */
    @ModelAnnotation(getName="法人代表手机号",column = "phone",isExport = true,defaultColumn=true)
    private String phone;

    /**
     * 法人身份证号
     */
    @ModelAnnotation(getName="法人身份证号",column = "legalpersonno",isExport = true)
    private String legalPersonNo;
    /**
     * 公司管理人员数
     */
    @ModelAnnotation(getName="公司管理人员数",column = "Companymanger",isExport = true)
    private Integer companymanger;

    /**
     *专业技术人员数
     */
    @ModelAnnotation(getName="专业技术人员数",column = "Technologynum",isExport = true)
    private Integer technologynum;

    /**
     * 公司用户面积
     */
    @ModelAnnotation(getName="公司用户面积",column = "Areanum",isExport = true)
    private String areanum;

    /**
     * 产权归属
     */
    @ModelAnnotation(getName="产权归属",column = "ascription",isExport = true)
    private String ascription;

    /**
     * 专属运输车辆数
     */
    @ModelAnnotation(getName="专属运输车辆数",column = "ascriptionvehicle",isExport = true)
    private Integer ascriptionvehicle;

    /**
     * 防暴枪支数
     */
    @ModelAnnotation(getName="防暴枪支数",column = "gunnum",isExport = true)
    private Integer gunnum;

    /**
     * 审查状态 0未审查 1 审查通过 2审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "censor_status",isExport = true)
    private String censorstatus;

    /**
     * 资料补正告知书
     */
    @ModelAnnotation(getName="资料补正告知书",column = "info_rar")
    private String infoRar;

    /**
     * 批复意见
     * @return
     */
    @ModelAnnotation(getName="批复意见",column = "replyreason")
    private String replyreason;


    /***
     * 批复附件
     */
    @ModelAnnotation(getName="批复附件",column = "reply_rar")
    private String replyRar;


    /***
     * 批复结果
     * 001 许可
     * 002 不许可
     * 003 整改
     */
    @ModelAnnotation(getName="批复结果",column = "reply_state")
    private String replyState;

    /**
     *制证状态    2已制证  0未制证  1提交审核
     */
    @ModelAnnotation(getName="制证状态",column = "card_state",isExport = true)
    private String cardState;

    /**
     * 批复，上传，制证按钮的标志位，在新审批中显示，旧审批中不显示
     * 1代表旧审批  空代表新审批
     */
    private String newOldFlag;

    /**
     * 其他保安服务范围名称(保安范围为其他则此列必填)
     */
    @ModelAnnotation(getName="其他保安服务范围名称",column = "otherSecScopeType",isExport = true)
    private String otherSecScopeType;

    /**
     * 保安服务许可类型
     */
    private String sponsorlicenseType;

    public String getSponsorlicenseType() {
        return sponsorlicenseType;
    }

    public void setSponsorlicenseType(String sponsorlicenseType) {
        this.sponsorlicenseType = sponsorlicenseType;
    }

    public String getOtherSecScopeType() {
        return otherSecScopeType;
    }

    public void setOtherSecScopeType(String otherSecScopeType) {
        this.otherSecScopeType = otherSecScopeType;
    }

    public String getNewOldFlag() {
        return newOldFlag;
    }

    public void setNewOldFlag(String newOldFlag) {
        this.newOldFlag = newOldFlag;
    }

    public String getCardState() {
        return cardState;
    }

    public void setCardState(String cardState) {
        this.cardState = cardState;
    }

    public String getReplyState() {
        return replyState;
    }

    public void setReplyState(String replyState) {
        this.replyState = replyState;
    }

    public String getReplyRar() {
        return replyRar;
    }

    public void setReplyRar(String replyRar) {
        this.replyRar = replyRar;
    }

    public String getReplyreason() {
        return replyreason;
    }

    public void setReplyreason(String replyreason) {
        this.replyreason = replyreason;
    }

    public String getInfoRar() {
        return infoRar;
    }

    public void setInfoRar(String infoRar) {
        this.infoRar = infoRar;
    }

    public String getCurrencybf() {
        return currencybf;
    }

    public void setCurrencybf(String currencybf) {
        this.currencybf = currencybf;
    }

    public String getCurrencyvaluebf() {
        return currencyvaluebf;
    }

    public void setCurrencyvaluebf(String currencyvaluebf) {
        this.currencyvaluebf = currencyvaluebf;
    }

    /**
     * 电话
     */
    public String getTel() {
        return this.tel;
    }

    /**
     * 电话
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 公司地址
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * 公司地址
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 邮编
     */
    public String getZipcode() {
        return this.zipcode;
    }

    /**
     * 邮编
     */
    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    /**
     * 经营范围
     */
    public String getManagement() {
        return this.management;
    }

    /**
     * 经营范围
     */
    public void setManagement(String management) {
        this.management = management;
    }

    /**
     * 企业类型
     */
    public String getEnterprisetype() {
        return this.enterprisetype;
    }

    /**
     * 企业类型
     */
    public void setEnterprisetype(String enterprisetype) {
        this.enterprisetype = enterprisetype;
    }

    /**
     * 注册资本
     */
    public Integer getRegcapital() {
        return this.regcapital;
    }

    /**
     * 注册资本
     */
    public void setRegcapital(Integer regcapital) {
        this.regcapital = regcapital;
    }

    /**
     * 注册资本验资或评估机构
     */
    public String getAssessmentorg() {
        return this.assessmentorg;
    }

    /**
     * 注册资本验资或评估机构
     */
    public void setAssessmentorg(String assessmentorg) {
        this.assessmentorg = assessmentorg;
    }

    /**
     * 货币资本
     */
    public Integer getCurrency() {
        return this.currency;
    }

    /**
     * 货币资本
     */
    public void setCurrency(Integer currency) {
        this.currency = currency;
    }

    /**
     *
     */
    public Integer getCurrencyvalue() {
        return this.currencyvalue;
    }

    /**
     *
     */
    public void setCurrencyvalue(Integer currencyvalue) {
        this.currencyvalue = currencyvalue;
    }

    /**
     * 拟任法定代表人
     */
    public String getRepresentative() {
        return this.representative;
    }

    /**
     * 拟任法定代表人
     */
    public void setRepresentative(String representative) {
        this.representative = representative;
    }

    /**
     *
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     *
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 公司管理人员数
     */
    public Integer getCompanymanger() {
        return this.companymanger;
    }

    /**
     * 公司管理人员数
     */
    public void setCompanymanger(Integer companymanger) {
        this.companymanger = companymanger;
    }

    /**
     *
     */
    public Integer getTechnologynum() {
        return this.technologynum;
    }

    /**
     *
     */
    public void setTechnologynum(Integer technologynum) {
        this.technologynum = technologynum;
    }

    /**
     * 公司用户面积
     */
    public String getAreanum() {
        return this.areanum;
    }

    /**
     * 公司用户面积
     */
    public void setAreanum(String areanum) {
        this.areanum = areanum;
    }

    /**
     * 产权归属
     */
    public String getAscription() {
        return this.ascription;
    }

    /**
     * 产权归属
     */
    public void setAscription(String ascription) {
        this.ascription = ascription;
    }

    /**
     * 专属运输车辆数
     */
    public Integer getAscriptionvehicle() {
        return this.ascriptionvehicle;
    }

    /**
     * 专属运输车辆数
     */
    public void setAscriptionvehicle(Integer ascriptionvehicle) {
        this.ascriptionvehicle = ascriptionvehicle;
    }

    /**
     * 防暴枪支数
     */
    public Integer getGunnum() {
        return this.gunnum;
    }

    /**
     * 防暴枪支数
     */
    public void setGunnum(Integer gunnum) {
        this.gunnum = gunnum;
    }

    //添加股东出资金额及所占比例
    private Shareholder shareholder;

    //公司总经理信息
    private SbSponsorlicenseManager sbSponsorlicenseManager;

    //公司副总经理信息
    private SbSponsorlicenseVmanager sbSponsorlicenseVmanager;

    public SbSponsorlicenseManager getSbSponsorlicenseManager() {
        return sbSponsorlicenseManager;
    }

    public void setSbSponsorlicenseManager(SbSponsorlicenseManager sbSponsorlicenseManager) {
        this.sbSponsorlicenseManager = sbSponsorlicenseManager;
    }

    public SbSponsorlicenseVmanager getSbSponsorlicenseVmanager() {
        return sbSponsorlicenseVmanager;
    }

    public void setSbSponsorlicenseVmanager(SbSponsorlicenseVmanager sbSponsorlicenseVmanager) {
        this.sbSponsorlicenseVmanager = sbSponsorlicenseVmanager;
    }

    public Shareholder getShareholder() {
        return shareholder;
    }

    public void setShareholder(Shareholder shareholder) {
        this.shareholder = shareholder;
    }

    public String getLegalPersonNo() {
        return legalPersonNo;
    }

    public void setLegalPersonNo(String legalPersonNo) {
        this.legalPersonNo = legalPersonNo;
    }

    public String getCensorstatus() {
        return censorstatus;
    }

    public void setCensorstatus(String censorstatus) {
        this.censorstatus = censorstatus;
    }

}