package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.CardNumber;
import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 保安员证考试报名
 *
 * @author subh
 */
@Data
@ModelTableAnnotation(getName = "保安员考试报名", tableName = "sb_personcertificate")
public class Personcertificate extends BusinessCommon {

    /**
     *
     */
    private static final long serialVersionUID = 8556407864044628410L;

    /**
     * 是否导出
     *
     * @return
     */
    public boolean isExport;

    public boolean isExport() {
        return isExport;
    }

    public void setExport(boolean export) {
        isExport = export;
    }

    private SecurityCertificate securityCertificate;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "姓名", isExport = true, column = "Name", defaultColumn = true, sign = SignType.LIKE)
    private String name;

    /**
     * 性别
     */
    @ModelAnnotation(getName = "性别", isExport = true, column = "Sex", needTranslate = true, dictName = "sex")
    private String sex;

    /**
     * 出生年月
     */
    @ModelAnnotation(getName = "出生年月", isExport = true, column = "Brith")
    private String brith;

    /**
     * 民族
     */
    @NotBlank(message = "民族不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "民族", isExport = true, column = "nation", specialTranslateType = "1", dictName = "nation")
    private String nation;

    /**
     * 政治面貌
     */
    @ModelAnnotation(getName = "政治面貌", column = "Politics", isExport = true, needTranslate = true, dictName = "politics")
    private String politics;

    /**
     * 文化程度
     */
    @NotBlank(message = "文化程度不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "文化程度", column = "Culture", isExport = true, needTranslate = true, dictName = "edu")
    private String culture;

    /**
     * 联系电话
     */
    @NotBlank(message = "联系电话不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "联系电话", column = "phone", isExport = true)
    private String phone;

    /**
     * 邮编
     */
    @ModelAnnotation(getName = "邮编", column = "Zipcode", isExport = true)
    private String zipcode;

    /**
     * 身份证号码
     */
    @CardNumber(message = "身份证号码格式不正确", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "身份证号码", isExport = true, column = "Cardnumber", defaultColumn = true, sign = SignType.LIKE)
    private String cardnumber;

    /**
     * 户籍地址
     */
    @NotBlank(message = "户籍地址不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "户籍地址", column = "address", isExport = true)
    private String address;

    /***
     * 申领状态
     */
    @ModelAnnotation(getName = "申领状态", column = "applyforstate", isExport = true)
    private String applyforstate;
    /**
     * 曾用名
     */
    @ModelAnnotation(getName = "曾用名", column = "beforeName", isExport = true)
    private String beforeName;

    /**
     * 社会保障卡
     */
    @ModelAnnotation(getName = "社会保障卡", column = "guaranteecar", isExport = true)
    private String guaranteecar;

    /**
     * 家庭电话
     */
    @ModelAnnotation(getName = "家庭电话", column = "familyPhone", isExport = true)
    private String familyPhone;
    /**
     * 兵役情况
     */
    @ModelAnnotation(getName = "兵役情况", column = "militaryService", isExport = true, needTranslate = true, dictName = "militaryService")
    private String militaryService;
    /**
     * 指纹卡号
     */
    @ModelAnnotation(getName = "指纹卡号", column = "fingerprint", isExport = true)
    private String fingerprint;

    /**
     * 宗教信仰
     */
    @ModelAnnotation(getName = "宗教信仰", column = "religion", isExport = true)
    private String religion;

    /***
     * 国籍
     */
    @ModelAnnotation(getName = "国籍", column = "nationality", isExport = true)
    private String nationality;

    /**
     * 籍贯
     */
    @ModelAnnotation(getName = "籍贯", column = "birthPlace", isExport = true)
    private String birthPlace;

    /**
     * 身高
     */
    @ModelAnnotation(getName = "身高", column = "hight", isExport = true)
    private String hight;
    /**
     * 血型
     */
    @ModelAnnotation(getName = "血型", column = "booldType", isExport = true)
    private String booldType;

    /**
     * 健康状况
     */
    @ModelAnnotation(getName = "健康状况", column = "healthStatus", isExport = true)
    private String healthStatus;
    /**
     * 现住地址
     */
    @NotBlank(message = "现住地址不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "现住地址", column = "nowAddress", isExport = true)
    private String nowAddress;
    /**
     * 备注
     */
    @ModelAnnotation(getName = "备注", column = "baseRemack", isExport = true)
    private String baseRemack;

    /**
     * 头像
     *
     * @return
     */
    private String heading;

    /***
     * 头像
     */
    @ModelAnnotation(getName = "头像", column = "imglogo")
    private String imglogo;

    /**
     * 保安员ID
     **/
    @ModelAnnotation(getName = "保安员ID", column = "personid")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personid;

    /**
     * 身份证正面
     **/
    @NotBlank(message = "身份证正面不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "身份证正面", column = "id_card_front")
    private String idCardFront;

    /**
     * 身份证反面
     **/
    @NotBlank(message = "身份证反面不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "id_card_reverse", column = "name")
    private String idCardReverse;

    /**
     * 县级以上医院出具的体检证明
     **/
    @ModelAnnotation(getName = "县级以上医院出具的体检证明", column = "health_examination")
    private String healthExamination;

    /**
     * 初中以上学历证明原件
     **/
    @ModelAnnotation(getName = "初中以上学历证明原件", column = "edu_photo")
    private String eduPhoto;

    /**
     * 无违法犯罪记录证明
     **/
    @ModelAnnotation(getName = "无违法犯罪记录证明", column = "nocrime_photo", isExport = true)
    private String nocrimePhoto;

    /**
     * 审查状态 001未审查 003 审查通过 004审查不通过
     */
    @ModelAnnotation(getName = "审查状态", column = "censor_status", isExport = true, needTranslate = true, dictName = "censorStatus")
    private String censorStatus;

    /**
     * 笔试成绩
     */
    @ModelAnnotation(getName = "笔试成绩", column = "written_score", isExport = true)
    private Integer writtenScore;

    /**
     * 实操成绩
     */
    @ModelAnnotation(getName = "实操成绩", column = "operate_score", isExport = true)
    private Integer operateScore;

    /**
     * 总成绩
     */
    @ModelAnnotation(getName = "总成绩", column = "sum_score", isExport = true)
    private Double sumScore;

    /**
     * 制证状态 1已制证 0未制证
     */
    @ModelAnnotation(getName = "制证状态", column = "card_state", isExport = true)
    private String cardState;

    /**
     * 考试状态 1通过0不通过
     */
    @ModelAnnotation(getName = "考试状态", column = "test_state", isExport = true, needTranslate = true, dictName = "testState")
    private String testState;
    /**
     * 确认制证状态 1已确认0未确认
     */
    @ModelAnnotation(getName = "确认制证状态", column = "confirmOrder")
    private String confirmOrder;
    /**
     * 指纹卡号状态1已录0未录
     */
    @ModelAnnotation(getName = "指纹卡号状态", column = "fingercard_state", isExport = true, needTranslate = true, dictName = "fingercardState")
    private String fingercardState;

    /**
     * 缴费状态 1已缴费 0 未缴费
     */
    @ModelAnnotation(getName = "缴费状态", column = "fee_state", isExport = true, needTranslate = true, dictName = "feeState")
    private String feeState;

    /**
     * 考试安排状态：0未安排，1已安排，2已取消,3 已修改
     */
    @ModelAnnotation(getName = "考试安排状态", column = "exam_state", isExport = true, needTranslate = true, dictName = "examState")
    private String examState;

    /**
     * 考试科目
     */
    @ModelAnnotation(getName = "考试科目", column = "exam_subject", isExport = true)
    private String examSubject;

    /**
     * 考点名称
     */
    @ModelAnnotation(getName = "考试点地址", column = "exam_address", isExport = true)
    private String examAddress;

    /**
     * 考试开始时间
     */
    @ModelAnnotation(getName = "考试开始时间", column = "exam_start", isExport = true)
    private String examStart;

    /**
     * 考试结束时间
     */
    @ModelAnnotation(getName = "考试结束时间", column = "exam_end", isExport = true)
    private String examEnd;

    /**
     * 考试次数
     */
    @ModelAnnotation(getName = "考试次数", column = "exam_times", isExport = true)
    private Integer examTimes;
    /**
     * 人员id
     */
    private Long bbdPersonID;
    /**
     * 机构id
     */
    @ModelAnnotation(getName = "机构id", column = "orgid")
    private Long orgID;

    /**
     * 证书表id
     */
    private Long cerId;

    /**
     * 科目ID
     */
    @ModelAnnotation(getName = "科目ID", column = "subject_id")
    private Integer subjectID;

    /**
     * 体能测试地址
     */
    @ModelAnnotation(getName = "体能测试地址", column = "stamina_address", isExport = true)
    private String staminaAddress;

    /**
     * 体能测试开始时间
     */
    @ModelAnnotation(getName = "体能测试开始时间", column = "stamina_startDate", isExport = true)
    private String staminaStartDate;

    /**
     * 体能测试结束时间
     */
    @ModelAnnotation(getName = "体能测试结束时间", column = "stamina_endDate", isExport = true)
    private String staminaEndDate;
    /***
     * 报名确认（001未确认002已确认）
     */
    @ModelAnnotation(getName = "报名确认", column = "signConfirm", isExport = true, needTranslate = true, dictName = "signConfirm")
    private String signConfirm;
    /***
     * 缴费确认状态
     */
    @ModelAnnotation(getName = "缴费确认状态", column = "payConfirm", isExport = true)
    private String payConfirm;

    // 同approval中的groupid，用做外网导入时判断所在审批阶段做通知
    @ModelAnnotation(getName = "groupid", column = "groupid")
    private String groupid;

    /**
     * 培训机构ID
     */
    @NotNull(message = "培训机构id不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训机构ID", column = "trainOrgID")
    private String trainOrgID;

    /**
     * 培训机构名称
     */
    @NotBlank(message = "培训机构不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "培训机构名称", column = "trainOrgName")
    private String trainOrgName;

    /**
     * 培训开始时间
     */
    @ModelAnnotation(getName = "培训开始时间", column = "trainStartDate")
    private Date trainStartDate;

    /**
     * 培训结束时间
     */
    @ModelAnnotation(getName = "培训结束时间", column = "trainEndDate")
    private Date trainEndDate;

    /**
     * 学习进度
     */
    @ModelAnnotation(getName = "学习进度", column = "learnRate")
    private int learnRate;


    /***
     * 人口库地址
     */
    private String populationAddress;
    /***
     * 发送单位的代码
     */
    private String policeCode;

    /***
     * 发送单位的名称
     */
    private String policeName;

    /**
     * 补考次数
     */
    private Integer makeUpCount;
    /**
     * 是否补考
     */
    @ModelAnnotation(getName = "是否补考", column = "isMakeUp", needTranslate = true, dictName = "isMakeUp")
    private String isMakeUp;

    /**
     * 流程状态  1 流程结束  其他 流程未结束
     */
    @ModelAnnotation(getName = "流程状态", column = "proState", needTranslate = true, dictName = "proState")
    private String proState;

    /**
     * 补考状态  003补考通过 004补考未通过
     */
    @ModelAnnotation(getName = "补考状态", column = "makeUpstate", needTranslate = true, dictName = "makeUpstate")
    private String makeUpstate;

    /**
     * 材料核对状态
     */
    @ModelAnnotation(getName = "材料核对状态", column = "checkState", needTranslate = true, dictName = "checkState")
    private String checkState;
    /**
     * 材料核对时间
     *
     */

    /**
     * 实操材料
     */
    private String trainMaterials;

    private Date checkDate;

    /**
     * 是否要申请补贴 1补贴 0不补贴
     */
    private String bonusApply;


    /**
     * 是否自然人 1是 0不是
     */
    @NotBlank(message = "请指定自然人状态", groups = {ThirdPartyTrain.class})
    private String naturalPer;


    /**
     * 户籍类型
     */
    @NotBlank(message = "户籍类型不能为空", groups = {ThirdPartyTrain.class})
    private String residentType;

    /**
     * 户籍所在地类型
     */
    private String residentPlaceType;

    /**
     * 合同ID
     */
    private Long comContractId;

    /**
     * 缴费公司id
     */
    private Long payComId;

    /**
     * 缴费公司名称
     */
    private String payComName;

    /**
     * 合同
     */
    private ComContract comContract;
    //背景筛查时是否有异常
    private Boolean censorStatusError = false;

    /**
     * 劳动合同起始时间
     */
    private Date contractStart;

    /**
     * 劳动合同结束时间
     */
    private Date contractEnd;

    /**
     * 家庭成员
     */
    List<Family> familyList;

    /**
     * 工作经历
     */
    List<Personworkexperience> workexperienceList;

    /***
     * 背景筛查结果
     */
    private List<BackgroundApproval> backgroundApprovals;

    public String getIsMakeUp() {
        return isMakeUp;
    }

    public void setIsMakeUp(String isMakeUp) {
        this.isMakeUp = isMakeUp;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}