package com.bcxin.ars.model.sb;

import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import java.util.Date;
import com.bcxin.ars.model.BaseModel;


/**
 * 保安员证核发对象
 *
 * @table sb_per_cer_grant
 * @author lin
 * @date 2022-09-01
 */
@Data
public class PerCerGrant extends BusinessCommon {

    private static final long serialVersionUID=1L;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮寄地址
     */
    private String address;
        
    /**
     * 姓名
     */
    private String name;
                
    /**
     * 身份证号
     */
    private String idnumber;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approvalid;

    private String nextPerson;

    public String getPoliceName(){
        if(this.getPolice() != null){
            return this.getSzss() + "/" + this.getPolice().getOrgname();
        }
        return this.getSzss();
    }

    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
