package com.bcxin.ars.model.sb;
import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/***
 * 报考等级证人员
 * @author subh
 */
@Data
public class GradePerson extends BaseModel {
    /** 姓名 */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true,sign= SignType.LIKE)
    private String name;
    /** 公民身份证号 */
    @ModelAnnotation(getName="公民身份证号",column = "idnum",isExport = true,sign= SignType.LIKE)
    private String idnum;
    /**
     * 审查状态 001未审查 003 审查通过 004审查不通过
     */
    @ModelAnnotation(getName="审查状态",column = "censorStatus",isExport = true,needTranslate = true,dictName = "censorStatus")
    private String censorStatus;
    /**
     * 审查不通过原因
     */
    @ModelAnnotation(getName="比对不通过原因",column = "reson",isExport = true,sign= SignType.LIKE)
    private String reson;
    /***
     * 审批不通过是否可以修改
     */
    @ModelAnnotation(getName="审批不通过是否可以修改",column = "noPassEdit")
    private String noPassEdit;

    /***
     * 审批状态
     */
    @ModelAnnotation(getName="审批状态",column = "approvalState",isExport = true,needTranslate = true,dictName = "approvalState")
    private String approvalState;
    /** 保安证编号 */
    @ModelAnnotation(getName="保安证编号",column = "securityCertificateNo",isExport = true,sign= SignType.LIKE)
    private String securityCertificateNo;
    /***
     * 公司ID
     */
    private Long companyId;
    /***
     * 人员ID
     */
    private Long personId;
    /***
     * 更新标记
     */
    private Boolean updateflag;
    /***
     * 公司名称
     */
    @ModelAnnotation(getName="公司名称",column = "companyName",isExport = true,sign= SignType.LIKE)
    private String companyName;
    /***
     * 培训机构名称
     */
    @ModelAnnotation(getName="培训机构名称",column = "trainOrgName",isExport = true,sign= SignType.LIKE)
    private String trainOrgName;

    /** 发证日期 */
    @ModelAnnotation(getName="发证日期",column = "fzrq",isExport = true)
    private Date fzrq;
    /***
     * 批次号
     */
    @ModelAnnotation(getName="批次号",column = "importBatchId")
    private String importBatchId;
    /***
     * 申诉状态001提交申诉002申诉通过003申诉不通过
     */
    @ModelAnnotation(getName="申诉状态",column = "appealState",isExport = true,needTranslate = true,dictName = "appealState")
    private String appealState;
    /***
     * 申诉内容
     */
    @ModelAnnotation(getName="申诉内容",column = "appealContext",isExport = true,sign= SignType.LIKE)
    private String appealContext;
    /***
     * 对内意见
     */
    @ModelAnnotation(getName="对内意见",column = "appealResonIn",isExport = true,sign= SignType.LIKE)
    private String appealResonIn;
    /***
     * 对外意见
     */
    @ModelAnnotation(getName="对外意见",column = "appealReson",isExport = true,sign= SignType.LIKE)
    private String appealReson;
    /***
     * 分局ID
     */
    @ModelAnnotation(getName="分局ID",column = "orgId")
     private Long orgId;
    /***
     * 分局名称
     */
    @ModelAnnotation(getName="申诉机构",column = "orgName",isExport = true)
    private String orgName;
   /***
     * 背景筛查列表
     */
    private  List<BackgroundApproval> backgroundApprovals;
    /***
     * 用户ID
     */
    @ModelAnnotation(getName="用户ID",column = "userId")
    private Long userId;
    @Override
    public boolean equals (Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

}
