package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 *sb_family
 *
 */
@Data
public class Family extends BaseModel {

    /**
    *姓名
    */
	@ModelAnnotation(getName="姓名",column = "name")
    private String name;

    /**
    *关系
    */
	@ModelAnnotation(getName="关系",column = "relationship")
    private String relationship;

    /**
    *工作单位
    */
	@ModelAnnotation(getName="工作单位",column = "Companyname")
    private String companyname;

    /**
    *岗位
    */
	@ModelAnnotation(getName="岗位",column = "post")
    private String post;

    /**
    *保安员证申请ID
    */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ModelAnnotation(getName="保安员证申请ID",column = "personcertificateid")
    private Long personcertificateid;

	/**
	 * 身份证类型
	 */
	@ModelAnnotation(getName="身份证类型",column = "identifType")
     private String identifType;

	/**
	 * 身份证号码
	 */
	@ModelAnnotation(getName="身份证号码",column = "identifnumber")
	private String identifnumber;

	/**
	 * 联系方式
	 */
	@ModelAnnotation(getName="联系方式",column = "phone")
	private String phone;

}