package com.bcxin.ars.model.sb;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.BusinessCommon;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招撤销备案实体 sb_confesscompanyundo
 */
public class Confesscompanyundo extends BusinessCommon {

    //备案登录号
    @ModelAnnotation(getName="备案登录号",isExport = true,column  = "loginnum")
    private String loginnum;
    //申请撤销备案日期
    @ModelAnnotation(getName="申请撤销备案日期",isExport = true,column  = "canceldate")
    private Date canceldate;
    //申请撤销备案日期
    private String canceldatestr;
    //备案日期
    @ModelAnnotation(getName="备案日期",isExport = true,column  = "badate")
    private Date badate;
    //备案日期
    private String badatestr;
    //撤销原因
    @ModelAnnotation(getName="撤销原因",isExport = true,column  = "cancelreson")
    private String cancelreson;
    //单位地址
    @ModelAnnotation(getName="单位地址",isExport = true,column  = "address")
    private String address;
    //法人姓名
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true)
    private String legalname;
    //法人身份证号
    @ModelAnnotation(getName="法人身份证号",isExport = true,column  = "legalcard")
    private String legalcard;
    //法人手机号
    @ModelAnnotation(getName="法人手机号",isExport = true,column  = "legalphone",defaultColumn = true)
    private String legalphone;
    //撤销申请书附件
    @ModelAnnotation(getName="撤销申请书附件",isExport = true,column  = "cancelapplyfj")
    private String cancelapplyfj;
    //单位法人资格证明材料
    @ModelAnnotation(getName="单位法人资格证明材料",isExport = true,column  = "legalzmcl")
    private String legalzmcl;
    //法人身份证正面
    @ModelAnnotation(getName="法人身份证正面",isExport = true,column  = "legalcardpicz")
    private String legalcardpicz;
    //法人身份证反面
    @ModelAnnotation(getName="法人身份证反面",isExport = true,column  = "legalcardpicf")
    private String legalcardpicf;
    //项目服务区域
    @ModelAnnotation(getName="项目服务区域",isExport = true,column  = "servicearea")
    private String servicearea;
    //审查状态
    @ModelAnnotation(getName="审查状态",isExport = true,column  = "censor_status",needTranslate = true,dictName = "censorStatus")
    private String censorstatus;
    //流程实例id
    private String processInstanceId;

    /**
     * 备案单路径
     */
    @ModelAnnotation(getName="备案单路径",isExport = true,column  = "confirmpath")
    private String confirmpath;
    /**
     * 登记证路径
     */
    @ModelAnnotation(getName="登记证路径",isExport = true,column  = "registerpath")
    private String registerpath;

    public String getLoginnum() {
        return loginnum;
    }

    public void setLoginnum(String loginnum) {
        this.loginnum = loginnum;
    }

    public Date getCanceldate() {
        return canceldate;
    }

    public void setCanceldate(Date canceldate) {
        this.canceldate = canceldate;
        if(canceldate!=null){
            SimpleDateFormat sf=new SimpleDateFormat("yyyy-MM-dd");
            this.setCanceldatestr(sf.format(canceldate));
        }
    }

    public Date getBadate() {
        return badate;
    }

    public void setBadate(Date badate) {
        this.badate = badate;
        if(badate!=null){
            SimpleDateFormat sf=new SimpleDateFormat("yyyy-MM-dd");
            this.setBadatestr(sf.format(badate));
        }
    }

    public String getCancelreson() {
        return cancelreson;
    }

    public void setCancelreson(String cancelreson) {
        this.cancelreson = cancelreson;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLegalname() {
        return legalname;
    }

    public void setLegalname(String legalname) {
        this.legalname = legalname;
    }

    public String getLegalcard() {
        return legalcard;
    }

    public void setLegalcard(String legalcard) {
        this.legalcard = legalcard;
    }

    public String getLegalphone() {
        return legalphone;
    }

    public void setLegalphone(String legalphone) {
        this.legalphone = legalphone;
    }

    public String getCancelapplyfj() {
        return cancelapplyfj;
    }

    public void setCancelapplyfj(String cancelapplyfj) {
        this.cancelapplyfj = cancelapplyfj;
    }

    public String getLegalzmcl() {
        return legalzmcl;
    }

    public void setLegalzmcl(String legalzmcl) {
        this.legalzmcl = legalzmcl;
    }

    public String getLegalcardpicz() {
        return legalcardpicz;
    }

    public void setLegalcardpicz(String legalcardpicz) {
        this.legalcardpicz = legalcardpicz;
    }

    public String getLegalcardpicf() {
        return legalcardpicf;
    }

    public void setLegalcardpicf(String legalcardpicf) {
        this.legalcardpicf = legalcardpicf;
    }

    public String getCanceldatestr() {
        return canceldatestr;
    }

    public void setCanceldatestr(String canceldatestr) {
        this.canceldatestr = canceldatestr;
    }

    public String getBadatestr() {
        return badatestr;
    }

    public void setBadatestr(String badatestr) {
        this.badatestr = badatestr;
    }

    public String getConfirmpath() {
        return confirmpath;
    }

    public void setConfirmpath(String confirmpath) {
        this.confirmpath = confirmpath;
    }

    public String getRegisterpath() {
        return registerpath;
    }

    public void setRegisterpath(String registerpath) {
        this.registerpath = registerpath;
    }

    public String getServicearea() {
        return servicearea;
    }

    public void setServicearea(String servicearea) {
        this.servicearea = servicearea;
    }

    public String getCensorstatus() {
        return censorstatus;
    }

    public void setCensorstatus(String censorstatus) {
        this.censorstatus = censorstatus;
    }

    public String getProcessInstanceId() {
        return processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

}
