package com.bcxin.ars.model.certificate;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/***
 * 保安员证信息表
 */
@Data
public class SecurityCertificate extends BaseModel {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 是否历史导入数据
     **/
    private String isOldData;


    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "姓名", column = "xm")
    private String xm;

    /**
     * 地址
     */
    @NotBlank(message = "地址不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "地址", column = "address")
    private String address;

    /***
     * 人口库地址
     */
    private String populationAddress;

    /**
     * 出生日期
     */
    @ModelAnnotation(getName = "出生日期", column = "csrq")
    private String csrq;

    /**
     * 公民身份证号
     */
    @NotBlank(message = "身份证不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "公民身份证号", column = "idnum")
    private String idnum;

    /**
     * 证书编号
     */
    @ModelAnnotation(getName = "证书编号", column = "zsbh")
    private String zsbh;

    /**
     * 发证日期
     */
    @ModelAnnotation(getName = "发证日期", column = "fzrq")
    private Date fzrq;

    /**
     * 制作日期
     */
    @ModelAnnotation(getName = "制作日期", column = "zzrq")
    private Date zzrq;

    /**
     * 制证状态
     */
    @ModelAnnotation(getName = "制证状态", column = "zzzt")
    private String zzzt;

    /**
     * 发证机关编号
     */
    @ModelAnnotation(getName = "发证机关编号", column = "fzjgbh")
    private String fzjgbh;

    /**
     * 发证机关名称
     */
    @ModelAnnotation(getName = "发证机关名称", column = "fzjgmc")
    private String fzjgmc;

    /**
     * 是否打印
     *
     * @return
     */
    @ModelAnnotation(getName = "是否打印", column = "isprint")
    private boolean isprint;


    /**
     * 头像图片（联名卡使用）
     * 银行同步直接取该照片；
     * 2、新增证书照片，照片获取顺序为：人口库>报名照片>一寸免冠彩照；
     * 3、已有的证书数据，依次跑批从 人口库>报名照片>一寸免冠彩照 获取。
     * 4、当一寸免冠彩照更新、证书信息更新时，重新更新资格证库，并重新推送给银行。
     */
    private String headImg;

    /**
     * 图片
     */
    private String photo;

    /**
     * 是否有照片
     */
    @ModelAnnotation(getName = "是否有照片", column = "havephoto")
    private boolean havephoto;


    /**
     * 打印次数
     */
    @ModelAnnotation(getName = "打印次数", column = "printcount")
    private String printcount;

    /**
     * 打印日期
     */
    @ModelAnnotation(getName = "打印日期", column = "printTime")
    private Date printTime;
    /***
     * 领取状态 0-未领取1-已领取
     */
    @ModelAnnotation(getName = "领取状态", column = "receiveState")
    private String receiveState;

    /***
     * 当前公司名称
     */
    private String sc_name;
    /***
     * 手机号码
     */
    private String phone;


    /**
     * 民族
     */
    private String nation;

    /**
     * 二维码
     *
     * @return
     */
    private String qrcode;
    /**
     * 保安员资格证申报ID
     *
     * @return
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long securitypersonid;

    /**
     * 证书状态 1正常2撤销3吊销
     *
     * @return
     */
    private String state;

    /**
     * 性别
     *
     * @return
     */
    private String sex;

    /**
     * 办事机构id
     *
     * @return
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long orgId;

    /**
     * 培训单位id
     *
     * @return
     */
    @NotNull(message = "培训单位id不能为空", groups = {ThirdPartyTrain.class})
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long trainId;

    /**
     * 培训单位
     *
     * @return
     */
    private String trainName;

    /**
     * 保安员id
     *
     * @return
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long personId;

    /**
     * 报名所在单位id
     *
     * @return
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long companyId;

    /**
     * 报名所在单位
     *
     * @return
     */
    private String companyName;

    /**
     * 考试时间
     *
     * @return
     */
    private String examDate;

    /**
     * 考试成绩
     *
     * @return
     */
    @NotBlank(message = "考试成绩不能为空", groups = {ThirdPartyTrain.class})
    private String score;

    /**
     * 撤销日期
     *
     * @return
     */
    private String cancelDate;

    /**
     * 撤销原因
     *
     * @return
     */
    private String cancelReason;

    /**
     * 撤销决定机构代码
     *
     * @return
     */
    private String cancelOrg;

    /**
     * 撤销决定机构
     *
     * @return
     */
    private String cancelOrgName;

    /**
     * 吊销原因
     *
     * @return
     */
    private String revokeReason;

    /**
     * 吊销决定机构代码
     *
     * @return
     */
    private String revokeOrg;

    /**
     * 吊销决定机构
     *
     * @return
     */
    private String revokeOrgName;

    /**
     * 吊销日期
     *
     * @return
     */
    private String revokeDate;

    /**
     * 电子证书地址
     */
    private String electronCerUrl;

    /**
     * 快照id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long snapshotId;

    /**
     * 是否抽取
     */
    private Boolean isDraw;

    private Boolean push;

    /**
     * 数据来源
     */
    private String dataSource;

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}