package com.bcxin.ars.model.approve;

import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.model.BaseModel;

/**
 * 审批模板环节关联
 *
 * @author zhangye
 * @since 2018-01-29 09:15:58
 */
@ModelTableAnnotation(getName = "审批模板环节关联",tableName = "approve_temp_link_rela")
public class ApproveTempLinkRela extends BaseModel {
	private static final long serialVersionUID = 1941804851L;

	/**
	 * 审批模板ID
	 */
	private Long approveTempId;

	/**
	 * 审批环节ID
	 */
	private Long approveLinkId;

	/**
	 * 排序
	 */
	private Integer seq;

	/**
	 * 环节配置状态（1为配置完成 ，0为未配置）
	 */
	private String linkSetStatus;

	/**
	 * 创建机构类型(1省级机构，其他市级机构)
	 */
	private String createType;

	public String getLinkSetStatus() {
		return linkSetStatus;
	}

	public void setLinkSetStatus(String linkSetStatus) {
		this.linkSetStatus = linkSetStatus;
	}

	public Long getApproveTempId() {
		return approveTempId;
	}

	public void setApproveTempId(Long approveTempId) {
		this.approveTempId = approveTempId;
	}

	public Long getApproveLinkId() {
		return approveLinkId;
	}

	public void setApproveLinkId(Long approveLinkId) {
		this.approveLinkId = approveLinkId;
	}

	public Integer getSeq() {
		return seq;
	}

	public void setSeq(Integer seq) {
		this.seq = seq;
	}

	public String getCreateType() {
		return createType;
	}

	public void setCreateType(String createType) {
		this.createType = createType;
	}

}