package com.bcxin.ars.model.appeal;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/***
 * 申诉信息
 * @author subh
 */
@Data
public class Appeal extends BaseModel {

    /**
     * 姓名
     */
    @ModelAnnotation(getName = "姓名", isExport = true, column = "name", sign = SignType.LIKE)
    private String name;

    /**
     * 公民身份证号
     */
    @ModelAnnotation(getName = "公民身份证号", isExport = true, column = "idnum", sign = SignType.LIKE)
    private String idnum;

    /**
     * 公司ID
     */
    @ModelAnnotation(getName = "公司ID", column = "companyId")
    private Long companyId;

    /**
     * 公司名称
     */
    @ModelAnnotation(getName = "公司名称", isExport = true, column = "companyName", sign = SignType.LIKE)
    private String companyName;

    /**
     * 审批状态
     */
    @ModelAnnotation(getName = "审批状态", isExport = true, column = "appealState", needTranslate = true, dictName = "appealState")
    private String appealState;

    /**
     * 申诉内容
     */
    @NotBlank(message = "申诉内容不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "申诉内容", isExport = true, column = "appealContext", sign = SignType.LIKE)
    private String appealContext;

    /**
     * 申诉机构ID
     */
    @ModelAnnotation(getName = "申诉机构ID", column = "orgId")
    private Long orgId;

    /**
     * 机构名称
     */
    @ModelAnnotation(getName = "机构名称", isExport = true, column = "orgName", sign = SignType.LIKE)
    private String orgName;

    /**
     * 对内申诉审批原因
     */
    @ModelAnnotation(getName = "对内申诉审批原因", isExport = true, column = "appealResonIn", sign = SignType.LIKE)
    private String appealResonIn;

    /**
     * 对外申诉审批原因
     */
    @ModelAnnotation(getName = "对外申诉审批原因", isExport = true, column = "appealReson", sign = SignType.LIKE)
    private String appealReson;

    /**
     * 申诉类型(见码表)
     */
    @NotBlank(message = "申诉类型不能为空", groups = {ThirdPartyTrain.class})
    @ModelAnnotation(getName = "申诉类型", isExport = true, column = "businesstype", needTranslate = true, dictName = "appealType")
    private String businesstype;
    /**
     * 申诉机构查询
     */
    @ModelAnnotation(getName = "申诉机构", isExport = true, column = "areaCode", sign = SignType.LIKE)
    private String areaCodeQuery;

    /**
     * 申诉时间查询开始时间
     */
    @ModelAnnotation(getName = "表彰查询开始时间", column = "create_time", sign = SignType.DATE_GREATER_EQUAL)
    private String createTimeStart;

    /**
     * 申诉时间查询结束时间
     */
    @ModelAnnotation(getName = "表彰查询结束时间", column = "create_time", sign = SignType.DATE_LESS_EQUAL)
    private String createTimeEnd;
    /**
     * 处理时间查询开始时间
     */
    @ModelAnnotation(getName = "表彰查询开始时间", column = "update_time", sign = SignType.DATE_GREATER_EQUAL)
    private String updateTimeStart;

    /**
     * 处理时间查询结束时间
     */
    @ModelAnnotation(getName = "表彰查询结束时间", column = "update_time", sign = SignType.DATE_LESS_EQUAL)
    private String updateTimeEnd;

    /**
     * 身份证正面
     */
    private String cardImgPositive;

    /**
     * 身份证反面
     */
    private String cardImgBack;

    /**
     * 手持身份证号
     */
    private String cardHold;

    /**
     * 业务ID
     */
    @NotNull(message = "业务id不能为空", groups = {ThirdPartyTrain.class})
    private Long businessid;

    /**
     * 认证照片
     */
    private String authImg;

    /**
     * 人口库照片
     */
    private String dataImg;

    /**
     * 附件
     */
    private String attFile;

    /**
     * 照片
     */
    private String photo;

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}