package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.model.task.TaskPersonScheduleDetail;

/**
 * 安保公司班次类
 * @author Ethan
 */
public class SecurityCompanySchedule extends BaseModel {
	private TaskPersonScheduleDetail taskPersonScheduleDetail;

	public TaskPersonScheduleDetail getTaskPersonScheduleDetail() {
		return taskPersonScheduleDetail;
	}

	public void setTaskPersonScheduleDetail(TaskPersonScheduleDetail taskPersonScheduleDetail) {
		this.taskPersonScheduleDetail = taskPersonScheduleDetail;
	}

	private static final long serialVersionUID = -6184717683219122680L;
	
	/**
	 * 区域编号
	 */
	@ModelAnnotation(getName="区域编号",column = "native_code")
	private Long nativeCode;
	
	/**
	 * 所属安保公司ID
	 */
	@ModelAnnotation(getName="所属安保公司ID",column = "company_id")
	private Long companyId;
	
	/**
	 * 班次名称
	 */
	@ModelAnnotation(getName="班次名称",column = "name")
	private String name;
	
	/**
	 * 班次开始时间
	 */
	@ModelAnnotation(getName="班次开始时间",column = "start_time")
	private String startTime;
	
	/**
	 * 班次结束时间
	 */
	@ModelAnnotation(getName="班次结束时间",column = "end_time")
	private String endTime;
	
	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	@Override
	public String toString() {
		return "SecurityCompanySchedule [companyId=" + companyId + ", name=" + name + ", startTime=" + startTime
				+ ", endTime=" + endTime + "]";
	}

}
