package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;

import java.util.ArrayList;
import java.util.List;

/**
 * 机构管理信息
 * @author Ethan
 */
public class Police extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 是否导出
	 * @return
	 */
	@ModelAnnotation(getName="是否导出",column = "isexport")
	public boolean isExport;

	public boolean isExport() {
		return isExport;
	}

	public void setExport(boolean export) {
		isExport = export;
	}

	/**
	 * 上级组织
	 */
	@JsonBackReference
	@JsonIgnoreProperties(value={"handler"})
	private Police parent;

	/**
	 * 下级组织
	 */
	@JsonManagedReference
	@JsonIgnoreProperties(value={"handler"})
	private List<Police> children = new ArrayList<Police>();

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;

	/**
	 * 数据区域
	 */
	@ModelAnnotation(getName="数据区域",column = "native_code")
	private Long nativeCode;

	/**
	 * 所属区域
	 */
	@ModelAnnotation(getName="所属区域",column = "area")
	private String area;

	/**
	 * 单位地址
	 */
	@ModelAnnotation(getName="单位地址",column = "address")
	private String address;

	/**
	 * 办公电话
	 */
	@ModelAnnotation(getName="办公电话",column = "tel")
	private String tel;

	/**
	 * 机构名称
	 */
	@ModelAnnotation(getName="机构名称",column = "orgname")
	private String orgname;

	/**
	 *联系电话
	 */
	@ModelAnnotation(getName="联系电话",column = "phone")
	private String phone;

	/**
	 * 机构简称
	 */
	@ModelAnnotation(getName="机构简称",column = "shortname")
	private String shortname;

	/**
	 * 备注
	 */
	@ModelAnnotation(getName="备注",column = "remarks")
	private String remarks;

	/**
	 * 联系人
	 */
	@ModelAnnotation(getName="联系人",column = "contact")
	private String contact;

	/**
	 * 上级机构
	 * @return
	 */
	@ModelAnnotation(getName="上级机构",column = "parent_org")
	private Long parentorg;

	/**
	 * 用户数
	 */
	@ModelAnnotation(getName="用户数",column = "usernum")
	private Long usernum;

	/**
	 * 排序序号
	 * @return
	 */
	@ModelAnnotation(getName="排序序号",column = "orderno")
	private Integer orderno;

	/**
	 * 单位代码
	 * @return
	 */
	@ModelAnnotation(getName="单位代码",column = "code")
	private String code;

	/**
	 * 操作类型  数据库中不存在
	 */
	private  String optype;
	@ModelAnnotation(getName="路径",column = "path")
	private  String path;
	@ModelAnnotation(getName="区域编码",column = "areacode")
	private String areacode;

	/**
	 * 机构类型 1 省级  2市级 3 县级 4 派出所
	 */
	@ModelAnnotation(getName="机构类型",column = "orgtype")
	private String orgtype;

	public String getOrgtype() {
		return orgtype;
	}

	public void setOrgtype(String orgtype) {
		this.orgtype = orgtype;
	}

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	public Long getNativeCode() {
		return nativeCode;
	}

	public void setNativeCode(Long nativeCode) {
		this.nativeCode = nativeCode;
	}

	public Police getParent() {
		return parent;
	}

	public void setParent(Police parent) {
		this.parent = parent;
	}

	public List<Police> getChildren() {
		return children;
	}

	public void setChildren(List<Police> children) {
		this.children = children;
	}
	
	public String getAreacode() {
		return areacode;
	}

	public void setAreacode(String areacode) {
		this.areacode = areacode;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getOptype() {
		return optype;
	}

	public void setOptype(String optype) {
		this.optype = optype;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getOrgname() {
		return orgname;
	}

	public void setOrgname(String orgname) {
		this.orgname = orgname;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getShortname() {
		return shortname;
	}

	public void setShortname(String shortname) {
		this.shortname = shortname;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}

	public Long getParentorg() {
		return parentorg;
	}

	public void setParentorg(Long parentorg) {
		this.parentorg = parentorg;
	}

	public Long getUsernum() {
		return usernum;
	}

	public void setUsernum(Long usernum) {
		this.usernum = usernum;
	}

	public Integer getOrderno() {
		return orderno;
	}

	public void setOrderno(Integer orderno) {
		this.orderno = orderno;
	}

	@Override
	public boolean equals (Object o){
		return super.equals(o);
	}

	@Override
	public int hashCode() {
		return super.hashCode();
	}

	@Override
	public String toString() {
		return "Police{" +
				"user=" + user +
				", userid=" + userid +
				", area='" + area + '\'' +
				", address='" + address + '\'' +
				", tel='" + tel + '\'' +
				", orgname='" + orgname + '\'' +
				", phone='" + phone + '\'' +
				", shortname='" + shortname + '\'' +
				", remarks='" + remarks + '\'' +
				", contact='" + contact + '\'' +
				", parent_org='" + parentorg + '\'' +
				", usernum=" + usernum +
				", orderno='" + orderno + '\'' +
				'}';
	}
}
