package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 服务合同信息
 * @author Ethan
 */
public class CyServerht extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",column = "user_id")
	private Long userid;


	/**
	 * 服务对象
	 */
	@ModelAnnotation(getName="服务对象",column = "serverobj")
	private String serverObj;

	/**
	 * 合同名称
	 */
	@ModelAnnotation(getName="合同名称",column = "htname")
	private String htName;

	/**
	 * 合同开始日期
	 */
	@ModelAnnotation(getName="合同开始日期",column = "htstartdate")
	private String htStartDate;

	/**
	 * 合同结束日期
	 */
	@ModelAnnotation(getName="合同结束日期",column = "htenddate")
	private String htEndDate;

	/**
	 * 合同编号
	 */
	@ModelAnnotation(getName="合同编号",column = "htnum")
	private String htNum;

	/**
	 * 合同年限
	 */
	@ModelAnnotation(getName="合同年限",column = "htlife")
	private String htLife;

	/***
	 * 合同状态
	 */
	@ModelAnnotation(getName="合同状态",column = "htstate")
	private String htstate;

	/***
	 *合同签订日期
	 */
	@ModelAnnotation(getName="合同签订日期",column = "htqdStartDate")
	private String htqdStartDate;

	/**
	 * 服务保安员人数
	 * @return
	 */
	@ModelAnnotation(getName="服务保安员人数",column = "securitynum")
	public Integer securityNum;

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}
	
	public Integer getSecurityNum() {
		return securityNum;
	}

	public void setSecurityNum(Integer securityNum) {
		this.securityNum = securityNum;
	}

	public String getHtqdStartDate() {
		return htqdStartDate;
	}

	public void setHtqdStartDate(String htqdStartDate) {
		this.htqdStartDate = htqdStartDate;
	}

	public String getHtstate() {
		return htstate;
	}

	public void setHtstate(String htstate) {
		this.htstate = htstate;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getServerObj() {
		return serverObj;
	}

	public void setServerObj(String serverObj) {
		this.serverObj = serverObj;
	}

	public String getHtName() {
		return htName;
	}

	public void setHtName(String htName) {
		this.htName = htName;
	}

	public String getHtStartDate() {
		return htStartDate;
	}

	public void setHtStartDate(String htStartDate) {
		this.htStartDate = htStartDate;
	}

	public String getHtEndDate() {
		return htEndDate;
	}

	public void setHtEndDate(String htEndDate) {
		this.htEndDate = htEndDate;
	}

	public String getHtNum() {
		return htNum;
	}

	public void setHtNum(String htNum) {
		this.htNum = htNum;
	}

	public String getHtLife() {
		return htLife;
	}

	public void setHtLife(String htLife) {
		this.htLife = htLife;
	}

	@Override
	public String toString() {
		return "CyServerht{" +
				"user=" + user +
				", userid=" + userid +
				", serverObj='" + serverObj + '\'' +
				", htName='" + htName + '\'' +
				", htStartDate='" + htStartDate + '\'' +
				", htEndDate='" + htEndDate + '\'' +
				", htNum='" + htNum + '\'' +
				", htLife='" + htLife + '\'' +
				'}';
	}
}
