package com.bcxin.ars.model;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 *监督检查情况
 * @author Ethan
 */
public class CyCheck extends BaseModel {

	private static final long serialVersionUID = 7649752662428917609L;

	/**
	 * 账户信息
	 */
	@JsonIgnoreProperties(value={"handler"})
	private User user;
	/**
	 * 用户ID
	 */
	@ModelAnnotation(getName="用户ID",isExport = true,column  = "user_id")
	private Long userid;

	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	/**
	 * 编号
	 */
	@ModelAnnotation(getName="编号",isExport = true,column  = "numno")
	private String numno;

	/**
	 *单位名称
	 */
	@ModelAnnotation(getName="单位名称",isExport = true,column  = "companyname")
	private String companyName;

	/**
	 * 单位编号
	 */
	@ModelAnnotation(getName="单位编号",isExport = true,column  = "companyno")
	private String companyNo;

	/**
	 * 检查日期
	 */
	@ModelAnnotation(getName="检查日期",isExport = true,column  = "checkdate")
	private String checkDate;

	/**
	 * 检查内容
	 */
	@ModelAnnotation(getName="检查内容",isExport = true,column  = "checkcontext")
	private String checkContext;

	/**
	 * 检查结果
	 */
	@ModelAnnotation(getName="检查结果",isExport = true,column  = "checkresult")
	private String checkResult;

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getNumno() {
		return numno;
	}

	public void setNumno(String numno) {
		this.numno = numno;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getCompanyNo() {
		return companyNo;
	}

	public void setCompanyNo(String companyNo) {
		this.companyNo = companyNo;
	}

	public String getCheckDate() {
		return checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}

	public String getCheckContext() {
		return checkContext;
	}

	public void setCheckContext(String checkContext) {
		this.checkContext = checkContext;
	}

	public String getCheckResult() {
		return checkResult;
	}

	public void setCheckResult(String checkResult) {
		this.checkResult = checkResult;
	}

	@Override
	public String toString() {
		return "CyCheck{" +
				"user=" + user +
				", userid=" + userid +
				", numno='" + numno + '\'' +
				", companyName='" + companyName + '\'' +
				", companyNo='" + companyNo + '\'' +
				", checkDate='" + checkDate + '\'' +
				", checkContext='" + checkContext + '\'' +
				", checkResult='" + checkResult + '\'' +
				'}';
	}
}
