package com.bcxin.ars.enums;

import com.bcxin.ars.model.*;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;

/**
 * 内到外同步数据表类型
 * @author linqinglin
 * @date 2019/04/01 0001 19:35
 */
public enum DataSyncType {

    DATASYC_APPROVAL_LIST{
        @Override
        public String getCode(){return "approval";}
        @Override
        public Class getClazz(){return Approval.class;}
        @Override
        public String getName(){return "审批信息";}
    },
    DATASYC_APPROVALLOG_LIST{
        @Override
        public String getCode(){return "approvalLog";}
        @Override
        public Class getClazz(){return ApprovalLog.class;}
        @Override
        public String getName(){return "审批对外日志";}
    },
    DATASYC_FILERECORD_LIST{
        @Override
        public String getCode(){return "filerecord";}
        @Override
        public Class getClazz(){return Filerecord.class;}
        @Override
        public String getName(){return "同步记录";}
    },
    DATASYC_PERSONCERTIFICATE_LIST{
        @Override
        public String getCode(){return "personcertificate";}
        @Override
        public Class getClazz(){return Personcertificate.class;}
        @Override
        public String getName(){return "保安员资格证报名";}
    },
    DATASYC_SECURITY_CERT_LIST{
        @Override
        public String getCode(){return "securityCertificate";}
        @Override
        public Class getClazz(){return SecurityCertificate.class;}
        @Override
        public String getName(){return "保安员证";}
    },
    DATASYC_POLICE_LIST{
        @Override
        public String getCode(){return "police";}
        @Override
        public Class getClazz(){return Police.class;}
        @Override
        public String getName(){return "公安机构";}
    },
    DATASYC_POLICEROLE_LIST{
        @Override
        public String getCode(){return "policeRole";}
        @Override
        public Class getClazz(){return PoliceRole.class;}
        @Override
        public String getName(){return "公安角色";}
    },
    DATASYC_USER_LIST{
        @Override
        public String getCode(){return "user";}
        @Override
        public Class getClazz(){return User.class;}
        @Override
        public String getName(){return "用户信息";}
    },
    DATASYC_SECURITYGUARD_LIST{
        @Override
        public String getCode(){return "securityGuard";}
        @Override
        public Class getClazz(){return SecurityGuard.class;}
        @Override
        public String getName(){return "保安师信息";}
    };


    public abstract String getCode();

    public abstract Class getClazz();

    public abstract String getName();

    public static void main(String[] args) {
        System.out.println(DataSyncType.DATASYC_APPROVAL_LIST.name());
        DataSyncType dataSyncType = DataSyncType.valueOf("DATASYC_APPROVAL_LIST");
        System.out.println(dataSyncType.getName());
    }

}
