package com.bcxin.ars.dto.sys;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

@Data
public class SysDictDto extends SearchDto<Sysdict>
{
    /**
     * 代码条目ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    private Integer sysDictId;

    /**
     * '是否有效'
     */
    private String isActive;

    /**
     * '代码类型'
     */
    private String codeType;

    /**
     * 代码所在表,NULL表示通用(因为存在同一个code在不同表值相同但含义不同的情况
     */
    private String tableName;

    /**
     * 代码中文描述
     */
    private String description;

    /**
     * 代码值
     */
    private String codeValue;

    /**
     * 代码值中文描述
     */
    private String label;

    /**
     * '排序'
     */
    @ModelAnnotation(isGrid = true,column ="seq",getName = "排序")
    private Integer seq;
}
