package com.bcxin.ars.dto.sb;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.sb.PerCheckRecord;
import lombok.Data;

import java.util.Date;


/**
 * 抽查记录查询dto
 *
 * @author lin
 * @date 2020-12-09
 */
@Data
public class PerCheckRecordPageSearchDto extends SearchDto<PerCheckRecord> {
    private static final long serialVersionUID = 1L;


    /**
     * 主键
     */
    private Long id;

    /**
     * 是否可用
     */
    private Boolean active;

    /**
     * 更新标识
     */
    private Boolean updateflag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 修改者
     */
    private String updateBy;

    /**
     * 数据区域
     */
    private String areaCode;

    /**
     * 业务id
     */
    private Long businessId;

    /**
     * 记录类型 01 资格证 03 等级证
     */
    private String recordType;

    /**
     * 审查结果 1抽查合格 2抽查不合格 3待复核
     */
    private String checkState;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号
     */
    private String idNum;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 人员id
     */
    private Long perId;

    /**
     * 公司id
     */
    private Long comId;

    /**
     * 公司名称
     */
    private String comName;

    /**
     * 培训学校id
     */
    private Long trainId;

    /**
     * 培训学校名称
     */
    private String trainName;

    /**
     * 抽查时间
     */
    private Date checkTime;

    /**
     * 抽查人员名称
     */
    private String checkName;

    /**
     * 抽查人员账号
     */
    private String userName;

    /**
     * 基本信息审查结果 1合格 0不合格
     */
    private String baseResult;

    /**
     * 基本信息审查意见
     */
    private String baseOpinion;

    /**
     * 学习照片审查结果 1合格 0不合格
     */
    private String studyResult;

    /**
     * 学习照片审查意见
     */
    private String studyOpinion;

    /**
     * 实习信息审查结果 1合格 0不合格
     */
    private String practiceResult;

    /**
     * 实习信息审查意见
     */
    private String practiceOpinion;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;
}
