package com.bcxin.ars.dto.page;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.EnrolmentLeaveBeijing;
import com.google.common.base.Objects;
import lombok.Data;

import java.util.Date;

/**
 * @author zhangyutong
 * Create by 2021/1/31 10:03
 */
@Data
public class EnrolmentLeaveBeijingSearchDto extends SearchDto<EnrolmentLeaveBeijing> {
    /**
     * 公司名称
     */
    private String comName;

    /**
     * 公司id
     */
    private Long comId;

    /**
     * 填写人
     */
    private String fillerName;

    /**
     * 填写人电话
     */
    private String fillerPhone;

    /**
     * 离京的保安员姓名
     */
    private String leavePersonName;

    /**
     * 离京的保安员身份证号
     */
    private String leavePersonIdNumber;

    /**
     * 离京的保安员手机号码
     */
    private String leavePersonPhone;

    /**
     * 离京时间
     */
    private Date leaveTime;

    /**
     * 离开准备去往的目的地
     */
    private String leaveDestination;

    /**
     * 预计归期
     */
    private Date leaveReturnTime;

    /**
     * 交通方式
     */
    private String leaveTransportation;

    /**
     * 到达日期
     */
    private Date arrivalTime;

    /**
     * 离京开始日期
     */
    private String leaveStartDate;

    /**
     * 离京结束日期
     */
    private String leaveEndDate;
    /**
     *返京开始日期
     */
    private String returnStartDate;
    /**
     * 返京结束日期
     */
    private String returnEndDate;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EnrolmentLeaveBeijingSearchDto that = (EnrolmentLeaveBeijingSearchDto) o;
        return Objects.equal(comName, that.comName) && Objects.equal(comId, that.comId) && Objects.equal(fillerName, that.fillerName) && Objects.equal(fillerPhone, that.fillerPhone) && Objects.equal(leavePersonName, that.leavePersonName) && Objects.equal(leavePersonIdNumber, that.leavePersonIdNumber) && Objects.equal(leavePersonPhone, that.leavePersonPhone) && Objects.equal(leaveTime, that.leaveTime) && Objects.equal(leaveDestination, that.leaveDestination) && Objects.equal(leaveReturnTime, that.leaveReturnTime) && Objects.equal(leaveTransportation, that.leaveTransportation) && Objects.equal(arrivalTime, that.arrivalTime);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), comName, comId, fillerName, fillerPhone, leavePersonName, leavePersonIdNumber, leavePersonPhone, leaveTime, leaveDestination, leaveReturnTime, leaveTransportation, arrivalTime);
    }
}
