package com.bcxin.ars.dto.page;


import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.Date;

/**
 * 代办事项查询dto
 *
 * @author lin
 * @Date 2020-01-21 10:39:58
 */
@Data
public class ApprovalOutTimePageSearchDto extends SearchDto<Approval> {

    /**
     * 对外审批意见
     */
    @ModelAnnotation(getName="对外审批意见",column = "outreason",isExport = true)
    private String outreason;

    /**
     *审批时间
     */
    @ModelAnnotation(getName="审批时间",column = "approvalDate",isExport = true)
    private Date approvaldate;

    /**
     * 申请时间
     */
    @ModelAnnotation(getName="申请时间",column = "create_time",isExport = true)
    private Date createTime;

    /**
     *审批状态
     */
    @ModelAnnotation(getName="审批状态",column = "approvalstate",isExport = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;

    /**
     *审批人
     */
    @ModelAnnotation(getName="审批人",column = "approvalperson",isExport = true)
    private String approvalperson;

    /**
     *业务类型
     */
    @ModelAnnotation(getName="业务类型",column = "businesstype",isExport = true,needTranslate = true,dictName = "businessType")
    private String businesstype;

    /**
     *业务ID
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ModelAnnotation(getName="业务ID",column = "businessid")
    private Long businessid;

    /**
     *业务审核查看链接
     */
    @ModelAnnotation(getName="业务审核查看链接",column = "businesslink")
    private String businesslink;

    /**
     *内容
     */
    @ModelAnnotation(getName="内容",column = "context",isExport = true)
    private String context;
    /***
     * 审批人Id
     */
    @ModelAnnotation(getName="审批人Id",column = "user_id")
    private Long userid;

    /***
     * 审批原因
     */
    @ModelAnnotation(getName="审批原因",column = "approvalreason",isExport = true)
    private String approvalreason;

    /***
     * 审批机构ID
     */
    @ModelAnnotation(getName="审批机构ID",column = "orgid")
    private Long orgid;


    /***
     * 审批配置ID
     */
    @ModelAnnotation(getName="审批配置ID",column = "configid")
    private Long configid;

    /***
     * 下一个审批人
     */
    @ModelAnnotation(getName="下一个审批人",column = "nextPerson",isExport = true,sign = SignType.NOTEMPTY)
    private String nextPerson;


    /**数据迁移关联的外网id **/
    private Long rawid;

    /**数据迁移关联的内网id **/
    private Long inrawid;

    /**
     * 资料补正告知书
     */
    @ModelAnnotation(getName="资料补正告知书",column = "info_rar")
    private String infoRar;

    /**
     * 对外意见附件
     */
    @ModelAnnotation(getName="对外意见附件",column = "outinfo_rar")
    private String outinfoRar;

    /**
     * 批复意见
     * @return
     */
    @ModelAnnotation(getName="批复意见",column = "replyreason")
    private String replyreason;

    /***
     * 批复状态
     */
    @ModelAnnotation(getName="批复状态",column = "replystate")
    private String replystate;
    /**
     * 批复附件
     * @return
     */
    @ModelAnnotation(getName="批复附件",column = "reply_rar")
    private String replyRar;


    /***
     * 角色ID
     */
    @ModelAnnotation(getName="角色ID",column = "roleid")
    private Long roleid;

    /***
     * 区域
     */
    @ModelAnnotation(getName="区域",column = "areaCode")
    private String areaCode;
    /***
     * 民警ID
     */
    @ModelAnnotation(getName="民警ID",column = "policeid")
    private Long policeid;

    /**
     * 流程id
     */
    @ModelAnnotation(getName="流程id",column  = "processInstanceId")
    private String processInstanceId;

    private String searchType;

    /**
     * 内网流程id
     */

    private String inProcessInstanceId;

    /**
     * 外网流程id
     */
    private String outProcessInstanceId;
    /****
     *超过几天未处理
     */
    @ModelAnnotation(getName="超过几天未处理",column  = "create_time",sign = SignType.OUTDAY)
    private String outDayUnHandle;
    /***
     * 申请时长
     */
    private String applyDays;
    /***
     * 当前审批候选组
     */
    @ModelAnnotation(getName="当前审批候选组",column = "groupid",sign = SignType.NOTEQUAL)
    private String groupid;

    /**
     * 流水号
     */
    @ModelAnnotation(getName="流水号",column = "serialNo")
    private String serialNo;

    /**
     * 确认单路径
     */
    @ModelAnnotation(getName="确认单路径",column = "confirmPath")
    private String confirmPath;

    /**
     * 登记证路径
     */
    @ModelAnnotation(getName="登记证路径",column = "registerPath")
    private String registerPath;

    /***
     * 任务ID
     */
    @ModelAnnotation(getName="任务ID",column = "taskDefinitionKey")
    private String taskDefinitionKey;

    /**
     * 是否旧版本审批的数据
     */
    private Boolean oldRev;

}