package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * sb_trainChange
 * 法人变更
 * <b>Function </b>
 *
 * @author LinQingLin
 * @date 2017年5月20日 下午12:36:31
 * @注意事项 </b>
 * <b>
 */
@Data
@ModelTableAnnotation(areaCodeFilter="1")
public class TrainChangeExportVDTO extends BaseModel {

    /**  */
    private static final long serialVersionUID = -2892981931790662070L;

    /**
     * 单位名称
     */
    @ModelAnnotation(getName="单位名称",isExport = true,column  = "companyname",defaultColumn = true,sign = SignType.LIKE)
    private String companyname;
    /**
     * 审批状态
     * 001未提交002待审核003审批通过004审批不通过
     */
    @ModelAnnotation(getName="审批状态",isExport = true,column  = "approvalstate",defaultColumn = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;
    /**
     * 提交日期（审批表）
     */
    @ModelAnnotation(getName="提交日期",column = "createTime",isExport = true,defaultColumn=true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;
    /**
     * 更新时间
     */
    @ModelAnnotation(getName="更新时间",column = "updateTime",isExport = true,defaultColumn=true)
    private Date updateTime;
    /** 提交时间查询开始时间 */
    @ModelAnnotation(getName="提交时间查询开始时间",column = "createTime",sign = SignType.DATE_GREATER_EQUAL)
    private String searchStartTime;

    /** 提交时间查询结束时间 */
    @ModelAnnotation(getName="提交时间查询结束时间",column = "createTime",sign = SignType.DATE_LESS_EQUAL)
    private String searchEndTime;
    /**
     * 变更项目
     *
     */
    @ModelAnnotation(getName="变更项目",isExport = true,column  = "changeName",defaultColumn = true)
    private String changeName;
    /**
     * 法人姓名
     */
    @ModelAnnotation(getName="法人姓名",isExport = true,column  = "legalname",defaultColumn = true,sign = SignType.LIKE)
    private String legalname;
    /**
     * 法人手机号（user表）
     */
    @ModelAnnotation(getName="法人手机号",column = "legalphone",isExport = true,defaultColumn=true,sign = SignType.LIKE)
    private String legalphone;
    /**
     * 单位地址
     */
    @ModelAnnotation(getName="单位地址",isExport = true,column  = "address")
    private String address;

    /**所在地县（区）代码**/
    @ModelAnnotation(getName="所在地县（区）代码",column  = "district",sign = SignType.LIKE)
    private String areaCode;

    /**
     * 下一审批人
     */
    @ModelAnnotation(getName="下一审批人",isExport = true,column  = "nextPerson")
    private String nextPerson;

    /**
     * 法人性别
     */
    @ModelAnnotation(getName="法人性别",isExport = true,column  = "legalsex",needTranslate = true,dictName = "sex")
    private String legalsex;

    /**
     * 任职时间
     */
    @ModelAnnotation(getName="任职时间",isExport = true,column  = "officetime")
    private Date officetime;
    /**
     * 证件类型
     */
    @ModelAnnotation(getName="证件类型",isExport = true,column  = "trainCardtype",needTranslate = true,dictName = "idCardType")
    private String trainCardtype;

    /**
     * 法人证件号码
     */
    @ModelAnnotation(getName="法人证件号码",isExport = true,column  = "trainCardnumber")
    private String trainCardnumber;
    /**
     * 拟定法人名称
     */
    @ModelAnnotation(getName="拟定法人名称",isExport = true,column  = "ndlegalname")
    private String ndlegalname;

    /**
     * 拟定法人性别
     */
    @ModelAnnotation(getName="拟定法人性别",isExport = true,column  = "ndlegalsex",needTranslate = true,dictName = "sex")
    private String ndlegalsex;

    /**
     * 拟定出生年月
     */
    @ModelAnnotation(getName="拟定法人出生年月",isExport = true,column  = "ndlegalbrith")
    private Date ndlegalbrith;

    /**
     * 拟定法人文化程度
     */
    @ModelAnnotation(getName="拟定法人文化程度",isExport = true,column  = "ndtrainCulture",needTranslate = true,dictName = "sex")
    private String ndtrainCulture;

    /**
     * 拟定法人证件类型
     */
    @ModelAnnotation(getName="拟定法人证件类型",isExport = true,column  = "ndtrainCardtype",needTranslate = true,dictName = "idCardType")
    private String ndtrainCardtype;

    /**
     * 拟定法人证件号码
     */
    @ModelAnnotation(getName="拟定法人证件号码",isExport = true,column  = "ndtrainCardnum")
    private String ndtrainCardnum;

    /**
     * 拟定法人国籍
     */
    @ModelAnnotation(getName="拟定法人国籍",isExport = true,column  = "ndlegalnationality")
    private String ndlegalnationality;

    /**
     * 拟定法人手机号码
     */
    @ModelAnnotation(getName="拟定法人手机号码",isExport = true,column  = "ndlegalphone")
    private String ndlegalphone;

    /**
     * 拟定法人户籍所在地
     */
    @ModelAnnotation(getName="拟定法人户籍所在地",isExport = true,column  = "ndlegaladdress")
    private String ndlegaladdress;

    /**
     * 拟定法人实际地址
     */
    @ModelAnnotation(getName="拟定法人实际地址",isExport = true,column  = "ndleaglsjaddress")
    private String ndleaglsjaddress;

    /**
     * 用户ID
     */
    /*@ModelAnnotation(getName="用户ID",isExport = true,column  = "userid")*/
    private Long userid;


    /**
     * 审批数据
     *
     */
    private Approval approval;

    /**
     * 审批人
     */
    /*@ModelAnnotation(getName="审批人",isExport = true,column  = "approvalperson")*/
    private String approvalperson;

    /**
     * 审批原因
     */
    /*@ModelAnnotation(getName="审批原因",isExport = true,column  = "approvalreason")*/
    private String approvalreason;

    /**
     * 审批时间
     */
    /*@ModelAnnotation(getName="审批时间",isExport = true,column  = "approvaldate")*/
    private Date approvaldate;

    /**
     * 压缩包地址
     */
    @ModelAnnotation(getName="压缩包地址",isExport = true,column  = "template_rar")
    private String templateRar;


    /**所在地省市县（区）**/
    @ModelAnnotation(getName="所属区域",isExport = true,column  = "szss")
    private String szss;

    /**所在地省代码**/
   /* @ModelAnnotation(getName="所在地省代码",isExport = true,column  = "province")*/
    private String province;

    /**所在地市代码**/
    /*@ModelAnnotation(getName="所在地市代码",isExport = true,column  = "city")*/
    private String city;


    /**
     * 派出所ID
     */
    /*@ModelAnnotation(getName="派出所ID",isExport = true,column  = "orgid")*/
    private Long orgid;

    /**
     * 原法定代表人审查状态
     */
    @ModelAnnotation(getName="原法定代表人审查状态",isExport = true,column  = "trainCensorstatus",needTranslate = true,dictName = "censorstatus")
    private String trainCensorstatus;

    /**
     *拟定法定代表人审查状态
     */
    @ModelAnnotation(getName="拟定法定代表人审查状态",isExport = true,column  = "ndtrainCensorstatus",needTranslate = true,dictName = "censorstatus")
    private String ndtrainCensorstatus;

    /**
     *单位负责人审查状态(0 未审查 1 审查通过 2审查不通过）
     */
    @ModelAnnotation(getName="单位负责人审查状态",isExport = true,column  = "chargecensorstatus",needTranslate = true,dictName = "censorStatus")
    private String chargecensorstatus;

    /**
     * 受理民警ID
     */
   /* @ModelAnnotation(getName="受理民警ID",isExport = true,column  = "policeid")*/
    private Long policeid;

    /***
     * 审批主键
     */
    private Long approvalId;

    /**
     * 派出所信息
     */
    private Police police;

    /**
     * 单位id
     */
    @ModelAnnotation(getName="单位id",isExport = false,column  = "companyid")
    private Long companyid;

    /**
     * 审批信息列表
     */
    private List approvallist;

    /**
     * 原单位名称
     */
    @ModelAnnotation(getName="原单位名称",isExport = false,column  = "oldcompanyname",defaultColumn = true)
    private String oldcompanyname;
}